#!/usr/bin/env bash
CUR_DIR=$(dirname $(readlink -f $0))
source $(dirname $(dirname ${CUR_DIR}))/util.sh
gaussdb_admin_pwd=$(get_info.py --gaussdb_admin_pwd)

function create_elem_db()
{
    log_info "Start init db"
    csbs_python /installfiles/comp/karbor/config.py
    if [ $? -ne 0 ];then
        log_error "Config karbor failed when init db."
        exit 1
    fi

    log_info "Start sync config"
    csbs_python /installfiles/syncsys/karbor_watcher.py sync
    if [ $? -ne 0 ];then
        log_error "Sync karbor config failed when init db"
        exit 1
    fi

    log_info "Start creat role"
    csbs_python -c "from basesdk import db_client;exit(db_client.create_role(\"karbor\"))"
    if [ $? -ne 0 ];then
        log_error "Create db role karbor failed"
        exit 1
    fi
    log_info "Success create role"

    log_info "Start create karbor_a user"
    csbs_python -c "from basesdk import db_client;exit(db_client.create_user_in_role(\"karbor\", \"karbor_a\"))"
    if [ $? -ne 0 ];then
        log_error "Create db user karbor_a failed"
        exit 1
    fi
    log_info "Success create karbor_a user"

    log_info "Start creat karbor_b user"
    csbs_python -c "from basesdk import db_client;exit(db_client.create_user_in_role(\"karbor\", \"karbor_b\"))"
    if [ $? -ne 0 ];then
        log_error "Create db user karbor_b failed"
        exit 1
    fi
    log_info "Success create karbor_b user"

    log_info "Start create karbor databse"
    csbs_python -c "from basesdk import db_client;exit(db_client.create_db_for_owner(\"karbor\", \"karbor\"))"
    if [ $? -ne 0 ];then
        log_error "Create db karbor failed"
        exit 1
    fi
    log_info "Success create karbor database"

    log_info "Init karbor db start"
    # if this execute fail, no problem, default user is karbor
    csbs_python /installfiles/comp/karbor/synconfig.py -c gaussdb -f /etc/karbor/karbor.conf -a karbor -p ${gaussdb_admin_pwd}
    if [ $? -ne 0 ];then
        log_error "Sysconfig karbor to conf error!"
    fi
    karbor-manage --config-file=/etc/karbor/karbor.conf db sync
    if [ $? -ne 0 ];then
        log_info "Init karbor db failed"
        exit 1
    fi

    log_info "Init karbor db success"
    kangaroo-manage --config-file=/etc/karbor/karbor.conf db_sync
    if [ $? -ne 0 ];then
        log_error "Init kangaroo table failed"
        exit 1
    fi

    log_info "Init kangaroo table success"
    kangaroo-manage --config-file=/etc/karbor/karbor.conf add_indexes
    if [ $? -ne 0 ];then
        log_error "Add indexes failed"
        exit 1
    fi

    log_info "Add indexes success"
    kangaroo-manage --config-file /etc/karbor/karbor.conf lock_initial karbor-operationengine
    if [ $? -ne 0 ];then
        log_error "Init karbor service lock failed"
        exit 1
    fi
    kangaroo-manage --config-file /etc/karbor/karbor.conf lock_initial rabbitmq
    if [ $? -ne 0 ];then
        log_error "Init karbor rabbitmq lock failed"
        exit 1
    fi
    log_info "Init karbor locks success"

    log_info "Start to register user and password to cms"
    data="{\\\"karbor_db_user\\\":\\\"karbor_a\\\",\\\"karbor_db_pass\\\":\\\"${gaussdb_admin_pwd}\\\"}"
    csbs_python -c "from basesdk import cms_info;exit(cms_info.put_cms_info(\"karbor.db_user_pass\", \"${data}\"))"
    if [ $? -ne 0 ];then
        log_error "Update karbor db user and password to cms failed"
        exit 1
    fi
    log_info "Success to register user and password to cms"

    log_info "Start to register role and password to cms"
    data="{\\\"karbor_db_role\\\":\\\"karbor\\\",\\\"karbor_db_pass\\\":\\\"${gaussdb_admin_pwd}\\\"}"
    csbs_python -c "from basesdk import cms_info;exit(cms_info.put_cms_info(\"karbor.db_role_pass\", \"${data}\"))"
    if [ $? -ne 0 ];then
        log_error "Update karbor db role and password to cms failed"
        exit 1
    fi
    log_info "Success to register role and password to cms"
    log_info "End init db"
}

create_elem_db
