#!/usr/bin/csbs_python
import time
import threading
import json
import sys
from basesdk import kazooClient
from basesdk import cms_info
from basesdk import utils
from kangaroo.config.karbor_config import KarborConfigManager
log = utils.get_logger("cms_watcher")
not_restart_key = ["ascagent.common.dns"]


def get_key():
    with open('/installfiles/syncsys/key.para') as fp:
        text = fp.read()
        key_list = json.loads(text)
        return key_list


def flush_conf(key, value):
    log.info("flush conf for key[%s]!" % key)
    kcm = KarborConfigManager()
    try:
        result = kcm.config_fun(key, value)
        if result:
            log.info("Write setting to file success!")
        else:
            log.info("No changes write to conf file")
        return result
    except Exception:
        log.error("Exception while handle %s = %s" % (key, value))
        return False


class KarborWatcher(threading.Thread):
    def __init__(self):
        super(KarborWatcher, self).__init__()
        self.zk_client = None
        self.key_list = get_key()
        self.watch_key = list()
        self.start()

    @staticmethod
    def restart_container():
        log.info("Start to restart processor!")
        status, out = utils.run_cmd(
            ['sh', '/installfiles/syncsys/restart_processor.sh'])
        return status == 0

    @staticmethod
    def try_restart_register(data):
        json_data = json.loads(data)
        if not json_data.get("cmc_endpoint"):
            return
        ret, out = utils.run_cmd(
            ["pgrep", "-f", "/usr/bin/operation-register"])
        if ret == 0 and out:
            utils.run_cmd(["kill", "-9", out])
        utils.run_cmd(
            ["proc_manager", "start", "/usr/bin/operation-register"])

    def date_change(self, data):
        try:
            key = data.decode().split(":")[0]
            log.info("Value of key({}) changed".format(key))
            value = cms_info.get_cms_info(key)
            result = flush_conf(key, value)
            if not result or key in not_restart_key:
                return
            if key == "karbor.endpoints":
                self.try_restart_register(value)
            if not self.restart_container():
                log.error("Setting sync received, "
                          "but restart container failed.")
        except Exception:
            log.error("Exception while handle config changed")

    def children_change(self, path, childrens):
        try:
            for children in childrens:
                if children not in self.key_list or children in self.watch_key:
                    continue
                self.watch_key.append(children)
                data_path = "%s/%s" % (path, children)
                kazooClient.register_data_watch(
                    self.zk_client, data_path, self.date_change)
        except Exception:
            log.error("Exception while handle children changed")

    def run(self):
        while 1:
            try:
                if not self.zk_client:
                    self.zk_client = kazooClient.get_zk_client_start(
                        utils.get_zk_ip())
                    kazooClient.register_children_watch(
                        self.zk_client,
                        cms_info.CMS_ROOT_NODE,
                        self.children_change)
            except Exception:
                log.error("Register children watch failed")
            time.sleep(10)


def sync_now():
    log.info("Start batch sync!")
    key_list = get_key()
    for key in key_list:
        try:
            value = cms_info.get_cms_info(key)
            flush_conf(key, value)
        except Exception:
            log.error("Flush key %s faild!" % key)
    log.info("End batch sync!")


if __name__ == '__main__':
    if len(sys.argv) >= 2:
        if sys.argv[1] == "sync":
            sync_now()
    else:
        KarborWatcher()
