#!/bin/bash
#容器内安装工具类
component="api"

function LOG ()
{
    logger -id -n 127.0.0.1 -p local1.$(echo $1 | tr "[A-Z]" "[a-z]") -t karbor-${component}"Control" "$1" "$(basename $0):$2 ${@:3}"
}

shopt -s expand_aliases
alias log_error='LOG ERROR $LINENO'
alias log_info='LOG INFO $LINENO'
alias log_warn='LOG WARN $LINENO'
alias log_debug='LOG DEBUG $LINENO'

function set_chown_chmod()
{
    chown -h root:openstack $1
    if [ -d $1 ] || [ -x $1 ];then
        chmod 750 $1
    else
        chmod 640 $1
    fi
}

function setprivilege()
{
    for file in $(find $(realpath $1) -group root);do
        set_chown_chmod ${file}
    done
    for file in $(find $(realpath $1) -nogroup);do
        set_chown_chmod ${file}
    done
    for file in $(find $(realpath $1) -nouser);do
        set_chown_chmod ${file}
    done
}