#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
PROFILE=$(get_info.py --profile)
LOG_FILE="/var/log/huawei/dj/install.log"

log_info "Begin to start karbor."
service rsyslog restart
log_info "Begin to start karbor-api."
karbor-apiControl -S RUN
if [ $? -ne 0 ]
then
    log_info "Retry start...cmd:karbor-apiControl -F RESTART."
    karbor-apiControl -F RESTART
fi
CHECK_RESULT "$?" "karbor-apiControl -S RUN"

log_info "Begin to start karbor-protection."
karbor-protectionControl -S RUN
if [ $? -ne 0 ]
then
    log_info "Retry start...cmd:karbor-protectionControl -F RESTART."
    karbor-protectionControl -F RESTART
fi
CHECK_RESULT "$?" "karbor-protectionControl -S RUN"

log_info "Begin to start karbor-operation."
karbor-operationControl -S RUN
if [ $? -ne 0 ]
then
    log_info "Retry start...cmd:karbor-operationControl -F RESTART."
    karbor-operationControl -F RESTART
fi
CHECK_RESULT "$?" "karbor-operationControl -S RUN"
if [[ ${PROFILE} != "public" ]];then
    /usr/bin/set_features --rpc_version v2.0 >/dev/null 2>&1
    CHECK_RESULT "$?" "set_features --rpc_version v2.0"
fi
log_info "End to start karbor."
