 #!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

KARBOR_PATH="/opt/huawei/dj/etc/karbor"
KARBOR_LOG_PATH="/var/log/huawei/dj/component/karbor"
KARBOR_SERVICES_DIR='/opt/huawei/dj/tools/services/karbor'
KARBOR_OPERATE_DIR='/var/log/huawei/dj/services/operate/karbor-api'
KARBOR_INSPECT_DIR='/opt/huawei/dj/inspect/sh'

function uninstall_img()
{
    #delete container instance
    log_info "Begin to delete container instance karbors..."
    docker ps -a | grep karbor | awk '{print $1}' | xargs -n1 docker rm -f >/dev/null 2>&1
    log_info "Delete container instance karbors finished."
    #delete image
    log_info "Begin to delete docker image..."
    docker images | grep karbor | awk '{print $3}'| xargs -n1 docker rmi -f >/dev/null 2>&1
    log_info "Delete docker image finished."
}

function uninstall_files()
{
    log_info "Remove links of karbor..."
    rm -f /usr/bin/karbor-apiControl
    rm -f /usr/bin/karbor-protectionControl
    rm -f /usr/bin/karbor-operationControl
    log_info "Remove file of karbor..."
    rm -rf ${KARBOR_PATH}
    rm -f /usr/bin/karbor_run.py
    rm -f /etc/rsyslog.d/rsyslog_karbor.conf
    rm -f /usr/bin/multi_func_exec.py
    log_info "Remove file of cms_watcher..."
    rm -f ${KARBOR_INSPECT_DIR}/karbor.sh
    rm -rf ${KARBOR_LOG_PATH}
    if [[ $? -ne 0 ]];then
        log_error "Remove log directory ${KARBOR_LOG_PATH} failed."
    fi
    log_info "Remove log directory ${KARBOR_LOG_PATH} success."
    rm -rf ${KARBOR_SERVICES_DIR}
    if [[ $? -ne 0 ]];then
        log_error "Remove log directory ${KARBOR_SERVICES_DIR} failed."
    fi
    log_info "Remove log directory ${KARBOR_SERVICES_DIR} success."
    rm -rf ${KARBOR_OPERATE_DIR}
    if [[ $? -ne 0 ]];then
        log_error "Remove log directory ${KARBOR_OPERATE_DIR} failed."
    fi
    log_info "Remove log directory ${KARBOR_OPERATE_DIR} success."
}

function stop_karbor()
{
    karbor-apiControl -S STOP
    karbor-protectionControl -S STOP
    karbor-operationControl -S STOP
}

function clean_crontab()
{
    sed -i '/purge\.sh/d' /etc/crontab
}

function main()
{
    log_info "Begin to uninstall karbor..."
    stop_karbor
    uninstall_img
    uninstall_files
    clean_crontab
    log_info "Uninstall karbor successfully."
}

main
exit 0