#!/usr/bin/env bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/karbor_upgrade.log"


function stop_service()
{
    karbor-apiControl -S STOP >> ${LOG_FILE} 2>&1
    karbor-protectionControl -S STOP >> ${LOG_FILE} 2>&1
    karbor-operationControl -S STOP >> ${LOG_FILE} 2>&1
}

function start_service()
{
    karbor-apiControl -S RUN >> ${LOG_FILE} 2>&1
    karbor-protectionControl -S RUN >> ${LOG_FILE} 2>&1
    karbor-operationControl -S RUN >> ${LOG_FILE} 2>&1
}


function rollback_backupfile()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function remove_container()
{
    cmd_retry "docker rm -f $1" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep $1 | wc -l`
    if [[ ${check_container} -ne 0 ]];then
        log_error "Remove $1 container failed."
        exit 1
    fi
}

function rollback_karbor_container()
{
    stop_service
    if [[ $? -ne 0 ]];then
        log_error "Stop karbor failed."
        return 1
    fi
    log_info "stop karbor success."
    remove_container "karborapi"
    remove_container "karborprotection"
    remove_container "karboroperation"
    log_info "remove container success."
    new_version=$(read_microservice_ver ${LINE_ROOT}/services/karbor/karbor.ver)
    remove_image "karbor:${new_version}"; CHECK_RESULT $?
    rollback_backupfile; CHECK_RESULT $?
    rollback_image ${CURRENT_DIR}/backup_files/ "karbor"
    if [[ $? -ne 0 ]];then
        log_error "Error to rollback karbor image."
        return 1
    fi
    log_info "Rollback karbor image success."
    start_service
    if [[ $? -ne 0 ]];then
        log_error "Start karbor failed."
        return 1
    fi
    log_info "Start karbor success."
    return 0
}

rollback_karbor_container
sed -i '/^karbor$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback karbor success."
exit 0