#!/bin/bash

SENDALARM_PATH="/opt/omm/oma/tools/sendAlarm"

#告警ID
ALARM_ID="1020710"

#告警产生位置
HOSTNAME=`get_info.py --hostname`
ALARM_LOCATION='send_meter_mission_to_docker_failed'

send_alarm()
{
    system_time=$(date +%s)
    $SENDALARM_PATH $ALARM_ID 0 2 '' $system_time 'meter' 'karbor-api' $ALARM_LOCATION $HOSTNAME
}

function meter()
{
    docker exec karborapi bash -c 'kangaroo-manage meter'
    if [ $? -eq 0 ];then
      return
    fi

    docker exec karborprotection bash -c 'kangaroo-manage meter'
    if [ $? -eq 0 ];then
      return
    fi

    docker exec karboroperation bash -c 'kangaroo-manage meter'
    if [ $? -eq 0 ];then
      return
    else
      send_alarm
    fi

}

meter
