#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
OMM_HA_LOG_PATH="/var/log/huawei/dj/services/system/ha"
LOG_FILE="${OMM_HA_LOG_PATH}/omm-haControl.log"
HA_INSTALL_PATH="/usr/local/bin/ha"
KMC_ROOT_KEY_PATH="/opt/huawei/dj/paas/KMCv3_rootKey"
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}
ServiceState=""
component="omm-ha"

function usage()
{
    echo "Usage: $prog -S ServiceState"
    echo "       $prog -h for help."
    exit 1
}

function showhelp()
{
    echo "Usage: $prog : -S ServiceState"
    echo "  -S ServiceState (RUN STOP)"
    echo "  -A RESTART"
    echo "  -CS CompontState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "${component}: illegal option"
    showhelp
    exit 1
}

function config_openssl()
{
    G_HA_CERT_DESTINATION="/usr/local/bin/ha/ha/local/cert"
    pushd ${G_HA_CERT_DESTINATION} >/dev/null
    rm -f ${G_HA_CERT_DESTINATION}/server.key
    encrypt_password=$(cat /opt/huawei/dj/DJSecurity/privkey/privkey.conf | awk '{print $2}')
    export ENCRYPT_DATA=${encrypt_password}
    pas2wd=$(csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")
    G_HA_KEYTOOL="/usr/local/bin/ha/ha/module/hacom/tools/key-tool"
    su -s /bin/sh openstack -c "${G_HA_KEYTOOL} -e  \"${pas2wd}\" | grep \"Encrypted\" | awk -F: '{print \$NF}' | tr -d ' ' > ${G_HA_CERT_DESTINATION}/server.key"
    chown -h openstack:openstack  ${KMC_ROOT_KEY_PATH} >/dev/null 2>&1
    su -s /bin/sh openstack -c "chmod 600 ${KMC_ROOT_KEY_PATH} >/dev/null 2>&1"
    HA_CERT_PATH="/opt/huawei/dj/DJSecurity/server-cert/omm-ha"
    CA_ROOT_PATH="/opt/huawei/dj/DJSecurity/server-ca"
    /usr/bin/cp -f ${HA_CERT_PATH}/omm-ha-key.pem ${G_HA_CERT_DESTINATION}/server.pem
    /usr/bin/cp -f ${HA_CERT_PATH}/omm-ha-cert.pem ${G_HA_CERT_DESTINATION}/server.crt
    /usr/bin/cp -f ${CA_ROOT_PATH}/ca-cert.pem ${G_HA_CERT_DESTINATION}/cacert.pem
    setprivilege ${G_HA_CERT_DESTINATION}
    popd >/dev/null
    local L_keypass=`cat ${G_HA_CERT_DESTINATION}/server.key`
    sudo -u openstack bash /usr/local/bin/ha/ha/module/hacom/script/config_ha.sh -q false -S ssl=true,twoway=true,rootca=${G_HA_CERT_DESTINATION}/cacert.pem,keypass=${L_keypass} > /dev/null
    CHECK_RESULT $?  "config openssl failed,Please Contact Huawei technical support."
}

function component_run()
{
    log_info "${component}Control: ======component_run begin"
    config_openssl >> /dev/null 2>&1
    sudo -u openstack bash /usr/local/bin/ha/ha/module/hamon/script/start_ha_monitor.sh
    heartBeat START omm-ha
    log_info "${component}Control: ======component_run end"
    return 0
}

function component_stop()
{
    log_info "${component}Control: ======component_stop begin"
    heartBeat STOP omm-ha
    sudo -u openstack bash /usr/local/bin/ha/ha/module/hamon/script/stop_ha_monitor.sh >> /dev/null 2>&1
    ps -ef | grep ha | grep module | grep ha_monitor | grep -v grep | awk '{print $2}' | xargs kill -9 >> /dev/null 2>&1
    sudo -u openstack bash /usr/local/bin/ha/ha/module/hacom/script/stop_ha.sh >> /dev/null 2>&1
    ps -ef | grep ha | grep module | grep ha.bin | grep -v grep | awk '{print $2}'| xargs kill -9 >> /dev/null 2>&1
    docker rm -f gaussdb >> /dev/null 2>&1
    log_info "${component}Control: ======component_stop end"
    return 0
}

function component_restart()
{
    log_info "${component}Control: ======component_restart begin"
    component_stop
    component_run
    log_info "${component}Control: ======component_restart end"
}

function component_statusget()
{
    queryCmd=`ps -eo pid,cmd ww | grep 'ha_monitor'| grep 'module' | grep -v grep| awk '{print $1}'`
    if [ -z "${queryCmd}" ]; then
        log_error "Query status of ${component} failed."
        return 1
    fi
    local status_info=$(sudo -u openstack bash /usr/local/bin/ha/ha/module/hacom/script/get_harole.sh)
    if [[ "${status_info}X" == "activeX" ]];then
        local ha_nodes=($(get_info.py omm-ha_nodes|sed 's/,/ /g'))
        if [[ "${#ha_nodes[@]}" == "1" ]];then
            return 0
        fi
        return 2
    fi
    if [[ "${status_info}X" == "standbyX" ]];then
        return 3
    fi
    return 0
}

function chown_chmod_ha_dir()
{
    if [[ ! -d "${OMM_HA_LOG_PATH}" ]]; then
      mkdir -p ${OMM_HA_LOG_PATH} >/dev/null 2>&1
    fi
    chown -hR openstack:openstack ${OMM_HA_LOG_PATH} >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/module/hasync >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/module/hamon >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/module/hacom >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/module/haarb >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/local >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/module/harm/conf >/dev/null 2>&1
    chown -hR openstack:openstack ${HA_INSTALL_PATH}/ha/module/harm/plugin/conf >/dev/null 2>&1
    chown -hR openstack:openstack /opt/huawei/dj/paas >/dev/null 2>&1
    chown -h openstack:openstack ${HA_INSTALL_PATH}/ha/module/harm/plugin/conf/hafloatIp.xml >/dev/null 2>&1
    su -s /bin/sh openstack -c "chmod -R 600 ${OMM_HA_LOG_PATH} >/dev/null 2>&1"
    su -s /bin/sh openstack -c "chmod -R 700 ${HA_INSTALL_PATH}/ha/module/haarb >/dev/null 2>&1"
    su -s /bin/sh openstack -c "chmod -R 700 ${HA_INSTALL_PATH}/ha/module/hacom >/dev/null 2>&1"
    su -s /bin/sh openstack -c "chmod -R 700 ${HA_INSTALL_PATH}/ha/module/hamon >/dev/null 2>&1"
    su -s /bin/sh openstack -c "chmod -R 700 ${HA_INSTALL_PATH}/ha/module/hasync >/dev/null 2>&1"
}

function export_ld_library_path()
{
    export_LD_LIBRARY_PATH="export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:\${LD_LIBRARY_PATH}"
    start_ha_monitor_sh="/usr/local/bin/ha/ha/module/hamon/script/start_ha_monitor.sh"
    start_ha_sh="/usr/local/bin/ha/ha/module/hacom/script/start_ha.sh"
    get_harole_sh="/usr/local/bin/ha/ha/module/hacom/script/get_harole.sh"
    ha_monitor=`cat ${start_ha_monitor_sh} | grep 'LD_LIBRARY_PATH' | awk -F '=' '{print $2}'`
    if [[ "${ha_monitor}" = "" ]];then
      sed -i "2 i\\${export_LD_LIBRARY_PATH}\n" ${start_ha_monitor_sh}
    fi
    ha_bin=`cat ${start_ha_sh} | grep 'LD_LIBRARY_PATH' | awk -F '=' '{print $2}'`
    if [[ "${ha_bin}" = "" ]];then
      sed -i "2 i\\${export_LD_LIBRARY_PATH}\n" ${start_ha_sh}
    fi
    ha_role=`cat ${get_harole_sh} | grep 'LD_LIBRARY_PATH' | awk -F '=' '{print $2}'`
    if [[ "${ha_role}" = "" ]];then
      sed -i "2 i\\${export_LD_LIBRARY_PATH}\n" ${get_harole_sh}
    fi
    sed -i '/hcpprocess:hcp/d' ${HA_INSTALL_PATH}/ha/module/hacom/script/functions/start_habin.sh
    sed -i '/hcpprocess:hcp/d' ${HA_INSTALL_PATH}/ha/module/hamon/script/start_ha_monitor.sh
}

log_info "INFO | #################begin exec omm-Control########################."
chown_chmod_ha_dir
export_ld_library_path
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2;;
        -CS) CompStatus=$2;shift 2;;
        -A) Action=$2;shift 2;;
        -h) showhelp $0;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    (
        component_restart
    )
    CHECK_RESULT $?
elif [ "RUN" = "${ServiceState}" ]; then
    (
        component_run
    )
    CHECK_RESULT $?
elif [ "STOP" = "${ServiceState}" ]; then
    (
        component_stop
    )
    CHECK_RESULT $?
elif [ "CompontState" = "${CompStatus}" ]; then
    (
        component_statusget
    )
    exit $?
else
    args_err
fi
exit 0
