#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
HA_CONFIG_SH="/usr/local/bin/ha/ha/module/hacom/script/config_ha.sh"
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}

function config_single_node()
{
    log_info "HA: begin to config single node omm-ha."
    bash ${HA_CONFIG_SH} -m single
    CHECK_RESULT $? "Error to config omm_ha in single node."
}

function judge_active_comp()
{
    local install_nodes=`get_info.py omm-ha_nodes`
    local active_mode=0
    local standby_mode=1
    local active_node=${install_nodes%%,*}
    if [[ "$1" == "${active_node}" ]];then
        echo ${active_mode}
    else
        echo ${standby_mode}
    fi
}


function config_peer_node()
{
    log_info "HA: begin to config peer node omm-ha."
    local local_ip=$(get_info.py manage_ip)
    local default_gateway=$(get_info.py default_gateway)
    case $(judge_active_comp ${local_ip}) in
    0) # active mode
        sh ${HA_CONFIG_SH} -m double -l ha1 -p ha2 -b ha1:[${local_ip}]:25555,ha2:[$1]:25555 -s ha1:${local_ip}:26666,ha2:[$1]:26666 -g ${default_gateway}  -j active >> ${LOG_FILE}
        CHECK_RESULT $? "Active add node failed."
    ;;
    1) # standby mode
        sh ${HA_CONFIG_SH} -m double -l ha2 -p ha1 -b ha2:[${local_ip}]:25555,ha1:[$1]:25555 -s ha2:${local_ip}:26666,ha1:[$1]:26666 -g ${default_gateway}  -j standby >> ${LOG_FILE}
        CHECK_RESULT $? "Standby add node failed."
    ;;
    *)
        log_error "The mode get form host error."
        exit 1
    ;;
    esac
}

function config_omm_ha()
{
    local ha_peer_node=`get_info.py ha_peer_node`
    if [[ "${ha_peer_node}" != "None" ]];then
        config_peer_node "${ha_peer_node}"
    else
        config_single_node
    fi
}

config_omm_ha