#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
IP_VERSION=`csbs_python /usr/bin/get_info.py --ip_version`
HA_INSTALL_PATH="/usr/local/bin/ha"
TOOL_PATH="/opt/huawei/dj/tools/services/omm-ha"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
VERSION_PATH="/opt/huawei/dj/versions/"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/omm-ha"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/omm-ha.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function pre_install_omm_ha()
{
    ha_conf="$1/module/hacom/conf/hacom.xml"
    if [[ $IP_VERSION != "ipv6" ]];then
        sed -i "s/::1/127.0.0.1/g" $ha_conf
    fi

    var_log="/var/log"
    ebk_log="/opt/huawei-data-protection/ebackup/logs"

    karbor_log="$var_log/huawei/dj/services/system"
    karbor_ha_log="$karbor_log/ha"

    habin_status="$1/module/hacom/script/functions/status_habin.sh"
    ha_status="$1/module/hacom/script/status_ha.sh"

    sed -i "s:$var_log:$karbor_log:g" $ha_conf
    sed -i "s:false:true:g" $ha_conf
    sed -i "s:$ebk_log:$karbor_ha_log:g" $habin_status
    sed -i "s:$ebk_log:$karbor_ha_log:g" $ha_status
}

######################################################################
#   FUNCTION   : install
#   DESCRIPTION: the ha should install on the host
######################################################################
function install_omm_ha()
{
    tar xvf ${LINE_ROOT}/repo/platform/omm-ha/HA*.tar.gz -C ${CURRENT_PATH}>> /dev/null
    CHECK_RESULT $? "Failed to exec tar axvf HA*.tar.gz."

    pre_install_omm_ha "${CURRENT_PATH}/HA*/software"
    rm -rf ${HA_INSTALL_PATH} && mkdir ${HA_INSTALL_PATH} -p
    bash ${CURRENT_PATH}/HA*/install.sh -p ${HA_INSTALL_PATH}
    CHECK_RESULT $? "Failed to exec install.sh in HA."

    /usr/bin/cp ${CURRENT_PATH}/arb/* ${HA_INSTALL_PATH}/ -rfp
    setprivilege ${HA_INSTALL_PATH}
    chmod 550 ${HA_INSTALL_PATH}/arbitrationtool/bin/configArb.sh
    log_info "Insttall HA*.tar.gz finish."

    /usr/bin/cp ${CURRENT_PATH}/hasync_mod.xml ${HA_INSTALL_PATH}/ha/module/hasync/plugin/conf/
    setprivilege ${HA_INSTALL_PATH}
    log_info "Insttall hasync_mod finish."

    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    setprivilege ${TOOL_PATH}
    create_link ${TOOL_PATH}/omm-haControl.sh
    chmod 550 ${TOOL_PATH}/*.sh
    log_info "Copy ${CURRENT_PATH}/cli_tool to ${TOOL_PATH}."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/inspect/omm-ha.sh ${INSPECT_SH_PATH}
    setprivilege ${INSPECT_SH_PATH}
    log_info "Copy omm-ha.sh to ${INSPECT_SH_PATH}."

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/omm-ha.ver ${VERSION_PATH}
    setprivilege ${VERSION_PATH}
    log_info "Copy omm-ha.ver to ${VERSION_PATH}."
}


function install_rsyslog()
{
    local rsyslog_conf_dir="/etc/rsyslog.d/"
    log_info "Copy rsyslog_ha.conf to ${rsyslog_conf_dir}..."
    /usr/bin/cp -f ${CURRENT_PATH}/rsyslog_ha.conf  ${rsyslog_conf_dir}
    CHECK_RESULT $? "Copy rsyslog_ha.conf ${rsyslog_conf_dir} failed."

    log_info "Restart rsyslog..."
    service rsyslog restart
    if [ $? -ne 0 ];then
       log_info "Restart rsyslog failed, wait 10 seconds to retry..."
       sleep 10
       service rsyslog restart
       log_info "Result code of restarting rsyslog is:$?"
    fi
}

function set_sudoers_for_omm_ha()
{
    sed -i "/\/omm-haControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/omm-ha/omm-haControl.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/configArb.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/local/bin/ha/arbitrationtool/bin/configArb.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/gaussdb.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/local/bin/ha/ha/module/harm/plugin/script/gaussdb.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/floatIp.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/local/bin/ha/ha/module/harm/plugin/script/floatIp.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/hafloatIp.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/local/bin/ha/ha/module/harm/plugin/script/hafloatIp.sh" >> /etc/sudoers.d/openstack
}

deploy_uninstall_script
install_omm_ha
install_rsyslog
set_sudoers_for_omm_ha