#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/omm-ha_upgrade.log"
source ${CURRENT_DIR}/util_omm-ha.sh

##########################################
#
#check upgrade version
#
##########################################
function check_version()
{
    # 不支持以升级的方式安装omm-ha
    if [ ! -f "/opt/huawei/dj/versions/omm-ha.ver" ];then
        echo "-1"
        exit 0
    fi
    is_need_upgrade omm-ha;ret_val=$?
    if [ ${ret_val} -eq 1 ]; then
        echo -1
        exit 0
    fi
}

###############################################################
# 功能说明: 获取节点升级顺序
# 入    参: NO
# 返 回 值: 主/NEXT_NODE, 备/FISTER_NODE, 未安装/LAST_NODE,
#           其他/ERROR_CODE
##############################################################
function order()
{
    local ha_nodes=($(get_info.py omm-ha_nodes|sed 's/,/ /g'))
    if [[ "${#ha_nodes[@]}" == "1" ]];then
        log_info "single node order:1."
        echo "${FISTER_NODE}"
        return 0
    fi
    local status=`check_omm_ha_a_or_s`
    case "${status}" in
    Primary)
        log_info "Primary node, return value: ${FISTER_NODE}."
        echo "${FISTER_NODE}"
        return 0
        ;;
    Standby)
        log_info "Standby node, return value: ${NEXT_NODE}."
        echo "${NEXT_NODE}"
        return 0
        ;;
    Not_install)
        log_info "Not_install node, return value: ${LAST_NODE}."
        echo "${LAST_NODE}"
        return 0
        ;;
    Normal)
        log_info "Normal node, return value: ${NEXT_NODE}."
        echo "${NEXT_NODE}"
        return 0
        ;;
    *)
        log_error "status is not right, error code."
        echo ""
        return 1
        ;;
    esac
}

function check_rollback()
{
    should_rollback read omm-ha
    if [ $? -ne 0 ];then
        log_info "do not need rollback"
        echo "-1"
        exit 0
    fi
}
if [[ $1 != "rollback" ]] && [[ $1 != "upgrade" ]];then
    echo "-1"
    exit 0
fi
if [[ $1 == "upgrade" ]];then
    check_version
fi
if [[ $1 == "rollback" ]];then
    check_rollback
fi

order;ret_val=$?
exit ${ret_val}