#!/bin/bash

# 从数据库中查出的数据库角色值
declare -r gs_r_primary="Primary"                       # 表示本端数据库作为主机使用。
declare -r gs_r_standby="Standby"                       # 表示本端数据库作为备机使用。
declare -r gs_r_normal="Normal"                         # 表示本端数据库作为单机使用。
declare -r gs_r_unknown="UNKNOWN"                       # 表示本端数据库以未知的方式使用。
declare -r gs_r_not_install="Not_install"
declare -i FISTER_NODE=1
declare -i NEXT_NODE=2
declare -i LAST_NODE=0
declare -i ERROR_CODE=-1
declare -r HA_VERSION_PATH="/opt/huawei/dj/versions/omm-ha.ver"
declare -r HA_INSTALL_PATH="/usr/local/bin/ha"
declare -r HA_BACKUP_PATH="/opt/huawei/dj/backup/DJ/services/omm-ha/"
declare -r BACKUP_PATH="${CURRENT_PATH}/upgrade_back"
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}


###############################################################
# 功能说明: 检查gaussdb容器进程以及同步数据状态, 超时时间6分钟
# 入    参: 
# 返 回 值: 0/ok, 1/not ok
##############################################################
function check_ha_container_service_syncstauts()
{
    for (( i=0; i<180; i++ ));do
        if  [[ $i == 179  ]];then
            return 1
        fi
        sleep 2
        ps -ef | grep module | grep ha.bin | grep -v grep > /dev/null 2>&1
        if [[ $? -ne 0 ]];then
            continue
        fi
        break
    done
    return 0
}

###################################################################
# 功  能: 检查ha主备
# 参  数： 无
# 返回值： 主: Primary, 
#          备: Standby, 
#          单节点: Normal
#          未安装: Not_install, 
#          异常: ERROR
####################################################################
function check_omm_ha_a_or_s()
{
    if [ ! -f ${HA_INSTALL_PATH}/ha/module/hacom/script/stop_ha.sh ];then
        echo "${gs_r_not_install}"
        return 0
    fi
    cd ${HA_INSTALL_PATH}/ha/module/hacom/script/
    for i in `seq 120`
    do
        local role_info=`bash ${HA_INSTALL_PATH}/ha/module/hacom/script/get_harole.sh`
        if [ ${role_info} == "standby" -o ${role_info} == "active" ]; then
            break
        fi
        sleep 5
    done
    cd - > /dev/null 2>&1
    log_info "get omm-ha status is: ${role_info}."
    if [[ "${role_info}" != "standby" ]] && [[ "${role_info}" != "active" ]];then
        log_error "get omm-ha status is: ${role_info}"
        echo "${gs_r_unknown}"
        return 1
    fi
    check_ha_container_service_syncstauts
    if [ $? -ne 0 ];then
        echo "${gs_r_unknown}"
        return 1
    fi
    if [[ "${role_info}" == "standby" ]];then
        echo "${gs_r_standby}"
        return 0
    fi
    echo "${gs_r_primary}"
    return 0
}
