#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
RABBITMQ_LOG_PATH="/var/log/huawei/dj/services/system/rabbitmq"
LOG_FILE=${RABBITMQ_LOG_PATH}/rabbitmqControl.log
SERV_IMG_VERSION=`read_microservice_ver /opt/huawei/dj/versions/rabbitmq.ver`
component="rabbitmq"
ServiceState=

function showhelp()
{
    usage="Usage: ${component} "
    len=${#component}
    echo "Usage: $component [-S RUN]"
    printf "%-${len}s[-S STOP]\n"
    printf "%-${len}s[-A RESTART]\n"
    printf "%-${len}s[-CS CompontState]\n"
    printf "%-${len}s[-h]\n"
    exit 1
}  

function heartBeatReg()
{
    heartBeat START rabbitmq
    log_info "REG rabbitmq heartBeat START successfully!"
}

function stopHeartBeat()
{
    heartBeat STOP rabbitmq
    log_info "Stop heartbeat of rabbitmq."
}

function component_statusget()
 {
    bash /opt/huawei/dj/inspect/sh/rabbitmq.sh rabbitmq_process
    if [ $? != 0 ]; then
        log_error "ERROR | rabbitmq status is fault"
        exit 1
    fi
    exit 0
}

function component_stop()
{
    log_info "${component}Control: ======component_stop begin"
    #stopHeartBeat
    stopHeartBeat
    docker rm -f ${component} >/dev/null 2>&1
    #rabitmq Up status
    docker ps -a | grep ${component} | grep -v grep | grep -w "Up"
    if [ $? -eq 0 ];then
        docker stop ${component}
    fi
    #rabitmq Exited status
    docker ps -a | grep ${component} | grep -v grep | grep -w "Exited"
    if [ $? -eq 0 ];then
        docker rm -f ${component} >/dev/null 2>&1
    fi
    #rabitmq Dead status
    docker ps -a | grep ${component} | grep -v grep | grep -w "Dead"
    if [ $? -eq 0 ];then
        docker rm -f ${component} >/dev/null 2>&1
    fi
    log_info "Stop component ${component} successfully."
    log_info "${component}Control: ======component_stop end"
}

function service_run_retry()
{
    #get version of docker engine
    local docker_version=`docker -v|awk -F'[ ,]' '{print $3}'|awk -F'.' '{print $2}'`
    CHECK_RESULT $? "Get docker version failed."
    docker_version=`expr ${docker_version} + 0`
    CHECK_RESULT $? "Docker version [${docker_version}] is invalid."
    log_info "Docker version is ${docker_version}."
    #docker security options
    local docker_security_opt="--memory 2048m --cpu-shares 2048 --security-opt=no-new-privileges --pids-limit 2048 --ulimit nofile=2048:2048"
    local retry=0
    while [ ${retry} -lt 3 ]
    do
        # docker run
        docker run -d --net=host --name=${component} \
            -v /etc/localtime:/etc/localtime:ro \
            -v /etc/hosts:/etc/hosts:ro \
            -v /usr/bin/get_info.py:/usr/bin/get_info.py:ro \
            -v /opt/huawei/dj/cfg:/opt/huawei/dj/cfg:ro \
            -v ${RABBITMQ_LOG_PATH}:${RABBITMQ_LOG_PATH} \
            -v /var/log/huawei/dj/services/system/kmc:/var/log/huawei/dj/services/system/kmc \
            -v /opt/huawei/dj/DJSecurity:/opt/huawei/dj/DJSecurity \
            -v /opt/huawei/dj/paas:/opt/huawei/dj/paas:ro \
            -v /opt/fusionplatform/data/openstack/:/opt/fusionplatform/data/openstack/ \
            ${docker_security_opt} \
            "${component}:${SERV_IMG_VERSION}" bash /usr/local/lib/rabbitmq/HW_FS_Extend/etc/init_service.sh >/dev/null 2>&1
        if [ "$?" == "0" ];then
            log_info "start ${component} container successfully."
            return 0
        fi
        log_info "start ${component} container failed, retry times:${retry}"
        c_id=`docker ps -a -q --no-trunc -f name=${component}`
        if [ "$?" == "0" ] && [ -n "${c_id}" ];then
            if [ -d "/run/containerd/${c_id}" ];then
                rm -fr "/run/containerd/${c_id}"
            fi
        fi
        sleep 1
        retry=$(( ${retry} + 1 ))

    done
    log_error "start ${component} container failed."
    return 1
}

function docker_run()
{
    # check rabbitmq status
    docker ps -a | grep ${component} | grep -v grep
    if [ $? -eq 0 ];then
        #rabitmq Exited status
        docker ps -a | grep ${component} | grep -v grep | grep -w "Exited"
        if [ $? -eq 0 ];then
            docker rm -f ${component} >/dev/null 2>&1
            if [ $? -ne 0 ];then
                log_error "Container ${component} is exit,remove failed."
                exit 1
            fi
        fi
        #rabitmq Dead status
        docker ps -a | grep ${component} | grep -v grep | grep -w "Dead"
        if [ $? -eq 0 ];then
            docker rm -f ${component} >/dev/null 2>&1
        fi
        #rabitmq Up status
        docker ps -a | grep ${component} | grep -v grep | grep -w "Up"
        if [ $? -eq 0 ];then
            log_info "Container ${component} is normal,no need to start."
            exit 0
        fi
    fi
    service_run_retry
    if [ $? -ne 0 ];then
        log_error "docker run rabbitmq image failed !"
        exit 1
    fi
    log_info "docker run rabbitmq image successfully."
    ps -ewwf |grep -v grep |grep beam |grep 'rabbit boot' >/dev/null 2>&1
    ret=$?
    for i in $(seq 1 20)
    do
    if [ $ret -ne 0 ];then
        log_info "check rabbitmq progress failed,try times:${i}."
        sleep 1
        ps -ewwf |grep -v grep |grep beam |grep 'rabbit boot' >/dev/null 2>&1
        ret=$?
    else
        log_info "check rabbitmq progress successfully!"
        return 0
    fi
    done
    return 0
}

function component_run()
{
    log_info "${component}Control: ======component_run begin"
    docker_run
    local ret_val=$?
    if [ $ret_val -ne 0 ];then
        log_error "Try to start ${component} failed."
        exit 1
    fi
    log_info "Component ${component} is running."
    heartBeatReg
    if [ $? != 0 ]; then
        log_error "======ERROR | rabbitmq reg heartBeat is failed."
    fi

    log_info "${component}Control: ======component_run end"
}

function component_restart()
{
    log_info "INFO | restart rabbitmq begin"
    component_stop
    sleep 2
    component_run
    log_info "INFO | restart rabbitmq end"
}

function args_err()
{
    echo -e "${component}: illegal option"
    showhelp
    exit 1
}

function chown_chmod_log_dir()
{
    mkdir -p ${RABBITMQ_LOG_PATH} >/dev/null 2>&1
    chown -h openstack:openstack  ${RABBITMQ_LOG_PATH} >/dev/null 2>&1
    chmod 750 ${RABBITMQ_LOG_PATH} >/dev/null 2>&1
}


log_info "INFO | #################begin exec rabbitmqControl########################."
chown_chmod_log_dir
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2;;
        -CS) CompStatus=$2;shift 2;;
        -A) Action=$2;shift 2;;
        -h) showhelp $0;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "$Action" ]; then
    component_restart 
    exit 0
elif [ "RUN" = "$ServiceState" ]; then
    component_run
    exit 0
elif [ "STOP" = "$ServiceState" ]; then
    component_stop
    exit 0
elif [ "CompontState" = "$CompStatus" ]; then
    component_statusget 
    exit 0
fi
exit 0




