#!/bin/bash
RABBITMQ_HOME="/usr/local/lib/rabbitmq"
source ${RABBITMQ_HOME}/HW_FS_Extend/etc/safe_config.sh
RABBITMQ_PID="/tmp/rabbitmq.pid"
LOCAL_IP=$(get_info.py manage_ip)
HOST_NAME="mq${LOCAL_IP//./}"
HOST_NAME="${HOST_NAME//:/}"
MNESIA_PATH=$(cat ${RABBITMQ_ENV_PATH} |grep RABBITMQ_MNESIA_BASE |awk -F '=' '{print $2}')
LOG_DIR=$(cat ${RABBITMQ_ENV_PATH} | grep RABBITMQ_LOG_BASE | awk -F '=' '{print $2}')


function init_pwd_stuff()
{
    if [[ "${LOG_DIR}x" == "x" ]]; then
        LOG_DIR=/var/log/huawei/dj/services/system/rabbitmq
        log_info "INFO | logDir not exist, use default"
    fi
    if [[ ! -d ${LOG_DIR} ]];then
        mkdir -p ${LOG_DIR}
    fi
    chown -h root:openstack ${LOG_DIR} >/dev/null 2>&1
    chmod 750 ${LOG_DIR} >/dev/null 2>&1
    saslfile=${LOG_DIR}/rabbit@${HOST_NAME}-sasl.log
    if [[ ! -f ${saslfile} ]]; then
        touch ${saslfile}
    fi
    nodefile=${LOG_DIR}/rabbit@${HOST_NAME}.log
    if [[ ! -f ${nodefile} ]]; then
        touch ${nodefile}
    fi
    logFile=${LOG_DIR}/rabbitmq.log
    if [ ! -f ${logFile} ]; then
        touch ${logFile}
    fi
    chmod 640 ${LOG_DIR}/* >/dev/null 2>&1

    if [[ "x" == "${MNESIA_PATH}x" ]]; then
        log_error "ERROR | rabbitmq db path is invalid. path=${mnesia_path}."
        return 1
    fi
    rm -rf ${MNESIA_PATH}/*
    mkdir -p ${MNESIA_PATH}
    mkdir -p ${MNESIA_PATH}/rabbit@${HOST_NAME}
}

function chmod_pwd_stuff()
{
    #chmod of password-related files after the rabbitmq-server is started
    ulimit -n 2000
    if [[ "x" == "${MNESIA_PATH}x" ]] || [[ ! -d ${MNESIA_PATH} ]]; then
        log_error "ERROR | rabbitmq db path is invalid. path=${MNESIA_PATH}."
        return 1
    fi
    mnesia_dir=${MNESIA_PATH}/rabbit@${HOST_NAME}
    chmod 640 ${mnesia_dir}/*.DCL >/dev/null 2>&1
    chmod 640 ${mnesia_dir}/*.DCD >/dev/null 2>&1
    chmod 640 ${mnesia_dir}/*.LOG >/dev/null 2>&1
}

function kill_rabbitmq()
{
    RABBITMQ_PID=`ps -efww|grep rabbit@${HOST_NAME}|grep -v grep|awk '{print $2}'`
    if [[ ! -z "${RABBITMQ_PID}" ]]; then
        kill -9 ${RABBITMQ_PID}
    fi
    epmd -kill > /dev/null 2>&1
}


log_info "INFO | #################begin exec rabbitmq start in container########################."
kill_rabbitmq
log_info "kill rabbitmq already running on this node."

init_pwd_stuff
check_result_and_safe_exit "$?" "Init rabbitmq path info failed."

restart_rabbitmq
check_result_and_safe_exit "$?" "ERROR | Start rabbitmq failed."

chmod_pwd_stuff
check_result_and_safe_exit "$?" "Chmod rabbitmq path failed."
log_info "INFO | Start rabbitmq successfully."
exit 0




