#!/bin/bash
source /usr/local/lib/rabbitmq/HW_FS_Extend/etc/safe_config.sh

function main()
{
    bash /usr/local/lib/rabbitmq/HW_FS_Extend/etc/SetState.sh
    check_result_and_safe_exit "$?" "Start service failed."
    log_info "Docker exec rabbitmq cmd successfully."

    proc_manager --start /usr/local/lib/rabbitmq/HW_FS_Extend/etc/rabbitmq_watch.py
    log_info "Rabbitmq watcher started."
    while :
    do
        pgrep -f /usr/local/lib/rabbitmq/HW_FS_Extend/etc/rabbitmq_watch.py
        if [[ $? -ne 0 ]];then
            log_info "No rabbitmq watcher process, restart it."
            proc_manager --start /usr/local/lib/rabbitmq/HW_FS_Extend/etc/rabbitmq_watch.py
        fi
        sleep 60
    done
}
main
exit 0