# coding=utf-8
from kmc import kmc

from basesdk import cms_info
from basesdk import utils

LOG = utils.get_logger("modify_password")
RABBITMQ_CTL = '/usr/local/lib/rabbitmq/sbin/rabbitmqctl'


if __name__ == '__main__':
    try:
        rabbitmq_pwd = cms_info.get_cms_info('rabbitmq.pwd')
        if not rabbitmq_pwd:
            LOG.error("Get rabbitmq.pwd failed.")
            exit(1)
        rabbitmq_decrypt = kmc.API().decrypt(0, rabbitmq_pwd)
        ret, _ = utils.run_cmd(
            [RABBITMQ_CTL, 'change_password', 'rabbit'],
            allow_log=False,
            sensitive_args=[rabbitmq_decrypt]
        )
        if ret != 0:
            LOG.error("Refresh rabbitmq conf failed.")
            exit(1)
        LOG.info("Refresh rabbitmq conf file OK.")
    except Exception:
        LOG.error("Modify password failed.")
        exit(1)
    exit(0)
