#!/bin/bash
source /installfiles/utils.sh

RABBIT_COOKIE="karbor_rabbit_cookie"
RABBITMQ_COOKIE_PATH="/home/openstack/.erlang.cookie"

function rabbitmq_deploy()
{
    rpm -Uivh --force --nodeps /installfiles/erlang-*.rpm
    CHECK_RESULT $? "Install erlang failed in docker"
    install_dir=$(mktemp -d /tmp/nameXXXXX)
    xz -d /installfiles/rabbitmq-server-*.tar.xz && tar xf /installfiles/rabbitmq-server-*.tar -C ${install_dir}
    CHECK_RESULT $? "Unzip rabbitmq-server failed in docker"
    /usr/bin/mv -f  ${install_dir}/rabbitmq*  /usr/local/lib/rabbitmq
    CHECK_RESULT $? "Move rabbitmq-server failed in docker"
    /usr/bin/cp -f /installfiles/rabbitmq.config /usr/local/lib/rabbitmq/etc/rabbitmq/
    /usr/bin/cp -f /installfiles/rabbitmq-env.conf /usr/local/lib/rabbitmq/etc/rabbitmq/
    /usr/bin/cp -rf /installfiles/HW_FS_Extend /usr/local/lib/rabbitmq
    setprivilege /usr/local/lib/rabbitmq
    mkdir -p /opt/huawei/dj/DJSecurity
    setprivilege /opt/huawei
    mkdir -p /var/log/huawei/dj/services/system/{rabbitmq,kmc}
    setprivilege /var/log/huawei
    # set bash env
    echo "PATH=\${PATH}:/usr/local/lib/rabbitmq/sbin" >> /etc/bashrc
    echo 'PS1="\[\e[32;1m\]\u@\h \w > \[\e[0m\]"' >> /etc/bashrc
    echo 'l="ls -lh"' >> /etc/bashrc
    echo 'll="ls -lh"' >> /etc/bashrc
    rm /installfiles -rf
    sed -i "s/tcp_listeners/ssl_listeners/g" /usr/local/lib/rabbitmq/sbin/rabbitmq-server
    chown -h openstack:openstack /usr/local/lib/rabbitmq/etc/rabbitmq/rabbitmq.config
    chmod 550 /usr/local/lib/rabbitmq/HW_FS_Extend/etc/*.py
    chmod 550 /usr/local/lib/rabbitmq/HW_FS_Extend/etc/*.sh

    echo ${RABBIT_COOKIE} >  ${RABBITMQ_COOKIE_PATH}
    chmod 600 ${RABBITMQ_COOKIE_PATH}
    chown openstack:openstack ${RABBITMQ_COOKIE_PATH}

    return 0
}
rabbitmq_deploy