#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
TOOL_PATH='/opt/huawei/dj/tools/services/rabbitmq'
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
VERSION_PATH="/opt/huawei/dj/versions/"


function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/rabbitmq"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/rabbitmq.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}


function install_rsyslog()
{
    /usr/bin/cp -rf ${CURRENT_PATH}/rsyslog_rabbitmq.conf /etc/rsyslog.d
    CHECK_RESULT $? "Copy rsyslog_rabbitmq.conf failed."
    service rsyslog restart
    if [ "$?" != "0" ];then
        sleep 10
        service rsyslog restart
    fi
    log_info "Copy rsyslog_rabbitmq.conf to /etc/rsyslog.d successfully."
    return 0
}


function install()
{
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -rf ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege  ${TOOL_PATH}
    create_link ${TOOL_PATH}/rabbitmqControl.sh
    CHECK_RESULT $? "Link ${TOOL_PATH}/rabbitmqControl failed."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/rabbitmq.sh ${INSPECT_SH_PATH}
    setprivilege  ${INSPECT_SH_PATH}
    CHECK_RESULT $? "Cp rabbitmq.sh to ${INSPECT_SH_PATH} failed."

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/rabbitmq.ver ${VERSION_PATH}
    setprivilege  ${VERSION_PATH}
    CHECK_RESULT $? "Cp rabbitmq.sh to /opt/huawei/dj/versions/ failed."
    return 0
}

function set_sudoers_for_rabbitmq()
{
    sed -i "/\/rabbitmqControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/rabbitmq/rabbitmqControl.sh" >> /etc/sudoers.d/openstack
}


function main()
{
    log_info "Begin to install rabbitmq..."
    deploy_uninstall_script
    install
    install_rsyslog
    set_sudoers_for_rabbitmq
    log_info "Install rabbitmq finished."
    return 0
}

main
log_info "Install rabbitmq successfully."
exit 0