#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/rabbitmq_upgrade.log"

CERT_PATH="/opt/huawei/dj/DJSecurity/server-cert/rabbitmq/"
ENCRYPT_PWD_PATH="/opt/huawei/dj/DJSecurity/privkey/privkey.conf"
SYS_INI="/opt/huawei/dj/cfg/sys.ini"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]]; then
        log_error "backup rabbitmq failed."
        return 1
    fi
    log_info "backup rabbitmq success."
    backup_image ${CURRENT_DIR}/backup_files/ "rabbitmq"
    if [[ $? -ne 0 ]];then
        log_error "Error to save rabbitmq image."
        # Compatible with 2 nodes to upgrade 3 nodes
        return 0
    fi
    log_info "backup rabbitmq image success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write rabbitmq
    if [ $? -ne 0 ];then
        log_error "failed to write rabbitmq upgrade flag."
        return 1
    fi
    log_info "success to write rabbitmq upgrade flag."
    return 0
}

function install_new_rabbitmq()
{
    bash ${CURRENT_DIR}/../uninstall.sh >/dev/null 2>&1
    bash ${CURRENT_DIR}/../merge.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "merge rabbitmq image failed."
        return 1
    fi
    log_info "merge rabbitmq image success."
    bash ${CURRENT_DIR}/../install.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "install rabbitmq  failed."
        return 1
    fi
    log_info "install rabbitmq  success."
    bash ${CURRENT_DIR}/../config.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "config rabbitmq  failed."
        return 1
    fi
    log_info "config rabbitmq success."
    bash ${CURRENT_DIR}/../start.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "start rabbitmq  failed."
        return 1
    fi
    log_info "start rabbitmq  success."
    return 0
}

function encrypt_private_key()
{
    cat /opt/huawei/dj/DJSecurity/server-cert/rabbitmq/rabbitmq-key.pem |grep "ENCRYPTED"  > /dev/null 2>&1
    if [[ $? -eq 0 ]];then
        return 0
    fi

    local encrypt_password=`cat ${ENCRYPT_PWD_PATH} | awk '{print $2}'`
    export ENCRYPT_DATA=${encrypt_password}
    local decrypt_password=`csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))"`
    if [[ ! -n "${decrypt_password}" ]];then
        log_error "Decrypt private key password failed."
        return 1
    fi

    local cert_name="rabbitmq"
    openssl rsa -aes256 -in ${CERT_PATH}/${cert_name}-key.pem -out ${CERT_PATH}/${cert_name}-key.pem -passout pass:${decrypt_password}
    if [[ $? -ne 0 ]];then
        log_error "Encrypt private key failed."
        return 1
    fi
    log_info "Encrypt private key success."
}

function set_rabbitmq_nodes()
{
    sed -i "/rabbitmq_nodes/d" ${SYS_INI}
    node_list=$(get_info.py manage_ip list)
    write_ini_file SYSTEM rabbitmq_nodes ${node_list} ${SYS_INI}
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    encrypt_private_key; CHECK_RESULT $?
    set_rabbitmq_nodes; CHECK_RESULT $?
    install_new_rabbitmq; CHECK_RESULT $?
}

main
log_info "upgrade rabbitmq successfully."
exit 0