#!/usr/bin/env bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
gaussdb_admin_pwd=$(get_info.py --gaussdb_admin_pwd)


log_info "Start creat role"
csbs_python -c "from basesdk import db_client;exit(db_client.create_role(\"resource_manager\"))"
if [[ $? -ne 0 ]];then
    log_error "Create db role resource_manager failed"
    exit 1
else
    log_info "Start to register role and password to cms"
    data="{\\\"db_role\\\":\\\"resource_manager\\\",\\\"db_pass\\\":\\\"${gaussdb_admin_pwd}\\\"}"
    csbs_python -c "from basesdk import cms_info;exit(cms_info.put_cms_info(\"resource_manager.db_role_pass\", \"${data}\"))"
    CHECK_RESULT $? "Register role and password to cms failed."
fi
log_info "Success create role"

log_info "Start create resource_manager_a user"
csbs_python -c "from basesdk import db_client;exit(db_client.create_user_in_role(\"resource_manager\", \"resource_manager_a\"))"
if [[ $? -ne 0 ]];then
    log_error "Create db user resource_manager_a failed"
    exit 1
else
    log_info "Start to register user and password to cms"
    data="{\\\"db_user\\\":\\\"resource_manager_a\\\",\\\"db_pass\\\":\\\"${gaussdb_admin_pwd}\\\"}"
    csbs_python -c "from basesdk import cms_info;exit(cms_info.put_cms_info(\"resource_manager.db_user_pass\", \"${data}\"))"
fi
log_info "Success create resource_manager_a user"

log_info "Start creat resource_manager_b user"
csbs_python -c "from basesdk import db_client;exit(db_client.create_user_in_role(\"resource_manager\", \"resource_manager_b\"))"
if [[ $? -ne 0 ]];then
    log_error "Create db user resource_manager_b failed"
    exit 1
fi
log_info "Success create resource_manager_b user"

log_info "Start create resource_manager databse"
csbs_python -c "from basesdk import db_client;exit(db_client.create_db_for_owner(\"resource_manager\", \"resource_manager\"))"
if [[ $? -ne 0 ]];then
    log_error "Create db resource_manager failed"
    exit 1
fi
log_info "Success create resource_manager database"