#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LOG_TAG="resource_manager_install"
source ${CURRENT_PATH}/utils.sh

csbs_python -m pip install --no-deps --force-reinstall  ${CURRENT_PATH}/resource_manager*.whl
CHECK_RESULT $? "install resource_manager in docker fail to install resource_manager.whl"

setprivilege ${CURRENT_PATH}
mkdir -p /opt/huawei/dj/{cfg,DJSecurity,bin,pass}
setprivilege /opt/huawei
CHECK_RESULT $? "Set installdir privilege failed."

create_link ${CURRENT_PATH}/resource_managerControl.sh
CHECK_RESULT $? "Create link file failed."
chown -hR openstack:openstack /usr/lib/csbs_python/site-packages/resource_manager*
chmod 550  ${CURRENT_PATH}/resource_manage_watcher.py
chown -hR openstack:openstack /etc/resource_manager
rm -f $0