#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LOG_TAG="resource_manager_start"
source ${CURRENT_PATH}/utils.sh
CONFIG_FILE="/etc/resource_manager/resource_manager.conf"
SERVICE_IP=$(cat ${CONFIG_FILE} | grep resource_manager_api_listen_ip | awk -F'=' '{print $NF}' | sed 's/ //g')
SERVICE_PORT=$(cat ${CONFIG_FILE} | grep resource_manager_api_listen_port | awk -F'=' '{print $NF}' | sed 's/ //g')
WORKER_COUNT=$(cat ${CONFIG_FILE} | grep resource_manager_api_workers | awk -F'=' '{print $NF}' | sed 's/ //g')
WORKER_COUNT=$(( ${WORKER_COUNT} + 1 ))


function showhelp()
{
    usage="Usage: resource_managerControl"
    len=${#usage}
    echo "Usage: resource_managerControl [-S RUN]"
    printf "%-${len}s [-S STOP]\n"
    printf "%-${len}s [-A RESTART]\n"
    printf "%-${len}s [-CS CompontState]\n"
    printf "%-${len}s [-h]\n"
    exit 1
}

function component_run()
{
    echo_info "Start resource_manager api begin."
    procNum=$(pgrep -f /usr/bin/resource_manager-api[[:space:]] | wc -l)
    if [[ "${procNum}" -ne 0 ]]; then
        echo_info "Processes for resource_manager api is running."
        echo_info "Start resource_manager api successfully."
        return 0
    fi
    proc_manager --start /usr/bin/resource_manager-api --config-file=${CONFIG_FILE}
    sleep 10
    component_statusget
    if [[ "$?" -eq 0 ]];then
        echo_info "Start resource_manager api successfully."
        return 0
    fi
    echo_error "Start resource_manager api failed."
    exit 1
}

function component_stop()
{
    echo_info "Stop resource_manager api begin"
    local retry=0
    while [[ ${retry} -lt 5 ]];do
        procNum=$(pgrep -f /usr/bin/resource_manager-api[[:space:]])
        if [[ "${procNum}" == "" ]]; then
            echo_info "resource_manager api is stopped"
            return 0
        fi
        kill -9 ${procNum}
        echo_info "Kill resource_manager api process $(echo ${procNum})"
        retry=$(( ${retry} + 1 ))
    done
    echo_error "Stop resource_manager api failed."
    exit 1
}

function component_restart()
{
    echo_info "Restart resource_manager api begin"
    component_stop
    component_run
    echo_info "Restart resource_manager api end"
}

function component_statusget()
{
    echo_info "Check resource_manager api status begin"
    local retry=0
    while [[ ${retry} -lt 10 ]];do
        sleep 10
        retry=$(( ${retry} + 1 ))
        procNum=$(pgrep -f /usr/bin/resource_manager-api[[:space:]] | wc -l)
        if [[ ${procNum} -ne ${WORKER_COUNT} ]]; then
            echo_warn "Check resource_manager api status failed, process number: ${procNum}, retry."
            continue
        fi
        curl -i -k https://${SERVICE_IP}:${SERVICE_PORT} >/dev/null 2>&1
        if [[ $? -eq 0 ]];then
            echo_info "Resource_manager api status is ok."
            return 0
        fi
    done
    echo_error "Resource_managerr api status is abnormal."
    return 1
}

function args_err()
{
    echo -e "resource_managerControl: illegal option"
    showhelp
}

case "$1 $2 $#" in
    "-S RUN 2")
        Action=$2
        ;;
    "-S STOP 2")
        Action=$2
        ;;
    "-A RESTART 2")
        Action=$2
        ;;
    "-CS CompontState 2")
        Action=$2
        ;;
    "-h  1")
        showhelp
        ;;
    *)
        args_err
        break
        ;;
esac

if [[ "RESTART" == "${Action}" ]]; then
    ret=$(pgrep -f "resource_managerControl[[:space:]]*-A[[:space:]]*RESTART")
    [[ "${ret}" != "$$" ]] && { echo_info "resource_managerControl -A RESTART is already running";exit 0;}
    component_restart
elif [[ "RUN" == "${Action}" ]]; then
    ret=$(pgrep -f "resource_managerControl[[:space:]]*-S[[:space:]]*RUN")
    [[ "${ret}" != "$$" ]] && { echo_info "resource_managerControl -S RUN is already running";exit 0;}
    component_run
elif [[ "STOP" == "${Action}" ]]; then
    ret=$(pgrep -f "resource_managerControl[[:space:]]*-S[[:space:]]*STOP")
    [[ "${ret}" != "$$" ]] && { echo_info "resource_managerControl -S STOP already running";exit 0;}
    component_stop
elif [[ "CompontState" == "${Action}" ]]; then
    component_statusget
fi
exit $?