#!/usr/bin/csbs_python
# -*- encoding:utf-8 -*-
import configparser
import sys
import json
from basesdk import utils

LOG = utils.get_logger("resource_manager_start")


class ConfigFile(object):
    def __init__(self, conf_file):
        self.cf = configparser.RawConfigParser()
        self.cf.read(conf_file)
        self.conf_file = conf_file

    def get_from_conf(self, section_name, key):
        if self.cf.has_option(section_name, key):
            return self.cf.get(section_name, key)

    def put_to_conf(self, section_name, key, value):
        self.cf.set(section_name, key, value)

    def flush(self):
        with open(self.conf_file, "w") as conf:
            self.cf.write(conf)


def change_single(section, key, value, replace_holder, cf):
    origin_value = cf.get_from_conf(section, key)
    if origin_value and replace_holder in origin_value:
        if value is None:
            value = ""
        origin_value = origin_value.replace(replace_holder, value)
        cf.put_to_conf(section, key, origin_value)
        LOG.info("Change_single section[{}], key[{}]".format(section, key))


def set_single(section, key, value, cf):
    cf.put_to_conf(section, key, value)
    LOG.info(f"Set single section({section}) key({key}) value({value})")


def replace_conf(value, sections, cf):
    for sect in sections:
        items = sections[sect]
        for item_key in items:
            replace_holder = items[item_key]
            if replace_holder:
                change_single(sect, item_key, value, replace_holder, cf)
            else:
                set_single(sect, item_key, value, cf)


def batch_change():
    cf = ConfigFile(sys.argv[1])
    with open(sys.argv[2], 'r') as key_file:
        key_map = json.loads(key_file.read())
    for key_index in key_map:
        try:
            value = utils.get_info(key_index)
            sections = key_map[key_index]
            replace_conf(value, sections, cf)
        except Exception:
            LOG.exception(f"batch_change key[{key_index}] Exception")
    cf.flush()


if __name__ == "__main__":
    if len(sys.argv) < 3:
        raise Exception('Sync Config paramer error.')
    batch_change()
