####################################################################
#TODO:以下日志输出和工具方法暂时放在脚本中,日志输出整改时替换到公共utils中
function LOG ()
{
    logger -id -p local1.$1 -t ${LOG_TAG} "$(basename $0):$2 ${@:4}"
    [[ "$3" -ne 0 ]] && echo "[$1] ${@:4}"
}
shopt -s expand_aliases
alias log_error='LOG error ${LINENO} 0'
alias log_info='LOG info ${LINENO} 0'
alias log_warn='LOG warn ${LINENO} 0'
alias log_debug='LOG debug ${LINENO} 0'
alias echo_error='LOG error ${LINENO} 1'
alias echo_info='LOG info ${LINENO} 1'
alias echo_warn='LOG warn ${LINENO} 1'
alias echo_debug='LOG debug ${LINENO} 1'

function CHECK_RESULT()
{
    [[ "$1" -ne 0 ]] && log_error "$2" && exit 1
}

function set_chown_chmod()
{
    chown -h openstack:openstack $1
    if [ -d $1 ] || [ -x $1 ];then
        chmod 700 $1
    else
        chmod 600 $1
    fi
}

function setprivilege()
{
    for file in $(find $(realpath $1) -user root);do
        set_chown_chmod ${file}
    done
    for file in $(find $(realpath $1) -nogroup);do
        set_chown_chmod ${file}
    done
    for file in $(find $(realpath $1) -nouser);do
        set_chown_chmod ${file}
    done
}

function create_link()
{
    chmod 750 $1
    name=$(basename ${1%%.*})
    rm -f /usr/bin/${name}
    ln -sf $1 /usr/bin/${name}
}
####################################################################