#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

function install_script()
{
    log_info "Init resource_manager uninstall configuration."
    mkdir -p /opt/huawei/dj/inst/services/resource_manager
    /usr/bin/cp -f ${CURRENT_PATH}/resource_manager.yaml /opt/huawei/dj/inst/services/resource_manager
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh /opt/huawei/dj/inst/services/resource_manager
    log_info "Finish resource_manager uninstall configuration."
}

function install_rsyslog()
{
    log_info "Init resource_manager rsyslog configuration."
    /usr/bin/cp -f ${CURRENT_PATH}/conf/rsyslog_resource_manager.conf /etc/rsyslog.d/
    CHECK_RESULT $? "Copy rsyslog_resource_manager failed."
    log_info "Restart rsyslog..."
    cmd_retry "service rsyslog restart" 60 5
    CHECK_RESULT $? "Restart rsyslog failed."
    log_info "Finish resource_manager rsyslog configuration."
}

function install_tools()
{
    log_info "Init resource_manager tools configuration."
    mkdir -p /opt/huawei/dj/tools/services/resource_manager
    /usr/bin/cp -f ${CURRENT_PATH}/tools/* /opt/huawei/dj/tools/services/resource_manager
    log_info "Setting resource_manager tools dir privilege."
    setprivilege  /opt/huawei/dj/tools/services/resource_manager
    log_info "Create resource_manager link."
    create_link /opt/huawei/dj/tools/services/resource_manager/resource_managerControl.sh
    log_info "Finsih resource_manager tools configuration."
}

function install_version()
{
    log_info "Init resource_manager version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f ${CURRENT_PATH}/resource_manager.ver /opt/huawei/dj/versions/
    log_info "Setting resource_manager version dir privilege."
    setprivilege  /opt/huawei/dj/versions/
    log_info "Finsih resource_manager version configuration."
}

function install_inspect()
{
    log_info "Init resource_manager inspect configuration."
    mkdir -p /opt/huawei/dj/inspect/sh/
    /usr/bin/cp -f ${CURRENT_PATH}/inspect/* /opt/huawei/dj/inspect/sh/
    log_info "Setting resource_manager inspect dir privilege."
    setprivilege  /opt/huawei/dj/inspect/sh/
    log_info "Finsih resource_manager inspect configuration."
}

function install_sudoers()
{
    log_info "Init resource_manager sudoers configuration."
    /usr/bin/cp -f ${CURRENT_PATH}/conf/sudo_resource_manager_conf /etc/sudoers.d/
    CHECK_RESULT $? "Copy sudo_resource_manager failed."
    log_info "Finish resource_manager sudoers configuration."
}



log_info "Start resource_manager installation."
install_rsyslog
install_script
install_tools
install_version
install_inspect
install_sudoers
log_info "Finish resource_manager installation."
