 #!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"


function uninstall_image()
{
    log_info "Begin to delete container instance resource_manager..."
    container=`docker ps -a -qf  name=resource_manager | wc -l`
    if [[ "${container}" -ne 0 ]];then
        docker ps -a | grep resource_manager | awk '{print $1}' | xargs -n1 docker rm -f >/dev/null 2>&1
    fi
    log_info "Delete container instance resource_manager finished."
    log_info "Begin to delete docker image..."
    images=`docker images -q resource_manager | wc -l`
    if [[ "${images}" -ne 0 ]];then
        docker images | grep resource_manager | awk '{print $3}'| xargs -n1 docker rmi -f >/dev/null 2>&1
    fi
    log_info "Delete resource_manager image finished."
}

function uninstall_files()
{
    log_info "Remove file of resource_manager rsyslog."
    rm -f /etc/rsyslog.d/rsyslog_resource_manager.conf
    log_info "Remove file of resource_manager crontab."
    rm -f /etc/cron.d/cron_resource_manager.conf
    log_info "Remove file of resource_manager sudoers."
    rm -f /etc/sudoers.d/sudo_resource_manager.conf
    log_info "Remove file of resource_manager inspect."
    rm -f /opt/huawei/dj/inspect/sh/resource_manager.sh
    log_info "Remove file of resource_manager version."
    rm -f /opt/huawei/dj/versions/resource_manager.ver
    log_info "Remove file of resource_manager tools."
    rm -rf /opt/huawei/dj/tools/services/resource_manager
    log_info "Remove file of resource_manager uninstall."
    rm -rf /opt/huawei/dj/inst/services/resource_manager
}

function stop_service()
{
    log_info "Stop resource_manager service."
    if [[ -f "/usr/bin/resource_managerControl" ]];then
        resource_managerControl -S STOP
        rm -f /usr/bin/resource_managerControl
    fi
}

log_info "Begin to uninstall resource_manager..."
stop_service
uninstall_image
uninstall_files
log_info "Uninstall resource_manager successfully."
