#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/resource_manager_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]]; then
        log_error "Backup resource_manager failed."
        return 1
    fi
    log_info "Backup resource_manager success."
    docker images  | grep resource_manager > /dev/null
    if [[ $? -ne 0 ]]; then
        log_warn "resource_manager images not exist."
        return 0
    fi
    backup_image ${CURRENT_DIR}/backup_files/ "resource_manager"
    if [[ $? -ne 0 ]];then
        log_error "Error to save resource_manager image."
        return 1
    fi
    log_info "Backup resource_manager image success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write resource_manager
    if [[ $? -ne 0 ]];then
        log_error "Failed to write resource_manager upgrade flag"
        return 1
    fi
    log_info "Success to write resource_manager upgrade flag."
    return 0
}


function upgrade_resource_manager()
{
    sh ${CURRENT_DIR}/../uninstall.sh
    log_info "uninstall old resource_manager success."
    sh ${CURRENT_DIR}/../merge.sh
    if [ $? -ne 0 ];then
        log_error "Merge resource_manager failed."
        return 1
    fi
    log_info "Merge new resource_manager success."
    sh ${CURRENT_DIR}/../install.sh
    if [ $? -ne 0 ];then
        log_error "Install new resource_manager failed."
        return 1
    fi
    log_info "Merge new resource_manager success."
    sh ${CURRENT_DIR}/../config.sh
    if [ $? -ne 0 ];then
        log_error "Config new resource_manager failed."
        return 1
    fi
    log_info "Config new resource_manager success."
    sh ${CURRENT_DIR}/../start.sh
    if [ $? -ne 0 ];then
        log_error "Start new resource_manager failed."
        return 1
    fi
    log_info "Start new resource_manager success."
}

function main()
{
    set_upgrade_flag; CHECK_RESULT $? "Failed to execute set_upgrade_flag."
    backup_files; CHECK_RESULT $? "Failed to execute backup_files."
    upgrade_resource_manager; CHECK_RESULT $? "Failed to execute merge_new_image."
}

main
log_info "Upgrade resource_manager success."
exit 0