#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
SCAGENT_BIN_PATH="/opt/huawei/dj/etc/scagent"
TOOL_PATH="/opt/huawei/dj/tools/services/scagent"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
VERSION_PATH="/opt/huawei/dj/versions/"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/scagent"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/scagent.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install()
{
    csbs_python -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/self_developed/scagent*.whl
    CHECK_RESULT $? "pip install scagent failed."
    setprivilege /usr/lib/csbs_python/site-packages
    setprivilege /opt/huawei/dj/etc/scagent

    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -rf ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege  ${TOOL_PATH}
    create_link ${TOOL_PATH}/scagentControl.sh
    CHECK_RESULT $? "Copy ${CURRENT_PATH}/cli_tools to ${TOOL_PATH} failed."

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/scagent.ver ${VERSION_PATH}
    setprivilege  ${VERSION_PATH}
    CHECK_RESULT $? "copy scagent.ver to ${VERSION_PATH} failed."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/scagent.sh ${INSPECT_SH_PATH}
    setprivilege  ${INSPECT_SH_PATH}
    CHECK_RESULT $? "copy scagent.sh to ${INSPECT_SH_PATH} failed."
}

function install_rsyslog()
{
    log_info "restart rsyslog..."
    /usr/bin/cp -f ${CURRENT_PATH}/rsyslog_scagent.conf /etc/rsyslog.d/
    service rsyslog restart
    if [ "$?" != "0" ];then
        sleep 10
        service rsyslog restart
    fi
    log_info "Copy rsyslog_scagent.conf to /etc/rsyslog.d successfully."
}

function set_sudoers_for_scagent()
{
    sed -i "/\/unify_passwd_manage.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/scagent/unify_passwd_manage.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/scagentControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/scagent/scagentControl.sh" >> /etc/sudoers.d/openstack
}

function main()
{
    log_info "begin to install scagent..."
    deploy_uninstall_script
    install
    install_rsyslog
    set_sudoers_for_scagent
    log_info "install scagent finished."
}

main
