#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/scagent_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "Rollback scagent failed."
        return 1
    fi
    log_info "Rollback scagent success."
    return 0
}

function main()
{
    scagentControl -S STOP; CHECK_RESULT $?
    rollback_files; CHECK_RESULT $?
    scagentControl -S RUN; CHECK_RESULT $?
}

main
sed -i '/^scagent$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback scagent success."
exit 0