#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/scagent_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "backup scagent failed."
        return 1
    fi
    log_info "backup scagent success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write scagent
    if [ $? -ne 0 ];then
        log_error "failed to write scagent upgrade flag."
        return 1
    fi
    log_info "success to write scagent upgrade flag."
    return 0
}

function install_new_scagent()
{
    bash ${CURRENT_DIR}/../uninstall.sh >/dev/null 2>&1
    bash ${CURRENT_DIR}/../install.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "install scagent  failed."
        return 1
    fi
    log_info "install scagent  success."
    bash ${CURRENT_DIR}/../start.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "start scagent  failed."
        return 1
    fi
    log_info "start scagent  success."
    return 0
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    install_new_scagent; CHECK_RESULT $?
}

main
log_info "upgrade scagent success."
exit 0