#!/bin/bash
if [[ ${UID} -ne 0 ]];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
source /opt/huawei/dj/inst/bin/utils.sh
CURRENT_DIR=`dirname $(readlink -f $0)`
SSH_KEY_OUT_FILE="/opt/huawei/dj/DJSecurity/ssh/set_zk_client_pwd"
SSH_OPT="-o StrictHostKeyChecking=no -i ${SSH_KEY_OUT_FILE}"
LOG_FILE="/var/log/huawei/dj/services/system/cli-client/cli-client.log"
ZK_CLI_CONF="/opt/fusionplatform/data/openstack/zkClient.conf"
ZK_CLI_CONF_BACKUP="/opt/fusionplatform/data/openstack/backup_zkClient.conf"
ZK_CLIENT_SCRIPT="/opt/huawei/dj/tools/services/zookeeper/set_zk_client_pwd.sh"
KEY="zk_client_pwd"
OPERATE=$1
SSH_FLAG=$2


function operate_zk_cli_pwd()
{
    # 先给zk的全部数据删除密码，再更新密码，再加密
    /usr/bin/cp -fpr ${ZK_CLI_CONF} ${ZK_CLI_CONF_BACKUP}
    cmd_retry "config_zookeeper rollback" 10 30
    CHECK_RESULT $? "Rollback zookeeper acl failed."
    if [[ ${OPERATE} == "update" ]];then
        pwd_info=`csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"${KEY}\"))"`
        if [[ -z "${pwd_info}" ]];then
            log_error "${KEY} data is empty."
            exit 1
        fi
        zookeeper_auth=`csbs_python -c "print(${pwd_info}.get(\"zookeeper_auth\"))"`
        if [[ -z "${zookeeper_auth}" ]];then
            log_error "${KEY} zookeeper_auth is empty."
            exit 1
        fi
        sed -i "2c data_kmc=${zookeeper_auth}" ${ZK_CLI_CONF}
    elif [[ ${OPERATE} == "rollback" ]];then
        /usr/bin/cp -fpr ${ZK_CLI_CONF_BACKUP} ${ZK_CLI_CONF}
    fi
    cmd_retry "zookeeperControl -A RESTART" 10 30
    CHECK_RESULT $? "Restart zookeeper failed."
    cmd_retry "config_zookeeper set_acl" 20 60
    CHECK_RESULT $? "Set zookeeper acl failed."
    cmd_retry "scagentControl -A RESTART" 10 30
    CHECK_RESULT $? "Restart scagent failed."
    log_info "${OPERATE} zookeeper client password successfully."
}

function main()
{
    local node_list=($(get_info.py manage_ip list|sed 's/,/ /g'))
    local cur_node=$(get_info.py manage_ip)
    for node in ${node_list[@]};do
        if [[ "${cur_node}" == "${node}" ]];then
            operate_zk_cli_pwd
            log_info "Current node(${node}) ${OPERATE} zookeeper client password success."
            continue
        fi
        # 如果是ssh过来的，只在本节点执行，不再ssh到其他节点
        if [[ "${SSH_FLAG}" == "ssh_flag" ]];then
            log_info "Called by other node which login by ssh."
            continue
        fi
        gen_ssh_key
        ssh ${SSH_OPT} djmanager@${node} ${ZK_CLIENT_SCRIPT} ${OPERATE} ssh_flag
        if [[ $? -ne 0 ]]; then
            log_error "Remote node(${node}) ${OPERATE} zookeeper client password failed."
            rm -f ${SSH_KEY_OUT_FILE}
            exit 1
        fi
        log_info "Remote node(${node}) ${OPERATE} zookeeper client password success."
    done
    log_info "All nodes ${OPERATE} zookeeper client password success."
    rm -f ${ZK_CLI_CONF_BACKUP}
    rm -f ${SSH_KEY_OUT_FILE}
    exit 0
}

main
