#!/bin/bash
LOCAL_IP=$(get_info.py manage_ip)
ZK_NODES=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))

function read_ini_file()
{
    local version=`awk -F '=' '/\['$2'\]/{a=1}a==1&&$1~/'$1'/{print $2;exit}' $3`
 	echo "${version}" | sed "s/^[ \t]*//g" | sed "s/[ \t]*$//g"
}

function modify_zoo_cfg()
{
    local conf_dir=/usr/local/bin/zookeeper/zookeeper/conf
    local zoo_cfg_location=${conf_dir}/zoo.cfg
    local data_dir=/usr/local/bin/zookeeper/zookeeper/data
    local authfile="/opt/fusionplatform/data/openstack/zkClient.conf"
    sed -i '/authProvider.1/d ' "${zoo_cfg_location}"
    echo "authProvider.1=com.huawei.dj.zookeeper.auth.EnhancedAuthenticationProvider" >> "${zoo_cfg_location}"
    sed -i '/clientPortAddress/d' ${zoo_cfg_location}
    sed -i '/clientPort/ a clientPortAddress='"${LOCAL_IP}"'' ${zoo_cfg_location}
    sed -i '/clientPort=/ c clientPort=9888' ${zoo_cfg_location}
    data=$(read_ini_file data_kmc zookeeper_auth ${authfile})
    hmac=$(read_ini_file data_kmc hmac_auth ${authfile})
    sed -i '/authData/d' ${conf_dir}/dj.properties
    sed -i '/hmacData/d' ${conf_dir}/dj.properties
    echo authData=${data} >> ${conf_dir}/dj.properties
    echo hmacData=${hmac} >> ${conf_dir}/dj.properties
    sed -i "/server./d" ${zoo_cfg_location}
    for ((i=0;i<${#ZK_NODES[@]};i++));do
        echo "server.$[i+1]=[${ZK_NODES[i]}]:2888:3888" >> ${zoo_cfg_location}
        if [[ "${LOCAL_IP}" == "${ZK_NODES[i]}" ]];then
            echo "$[i+1]" > ${data_dir}/myid
        fi
    done
}

function main()
{
    modify_zoo_cfg
    while true;do
        local zk_stus=`bash /usr/local/bin/zookeeper/zookeeper/bin/zkServer.sh status 2>/dev/null | grep -w "^Mode:" | awk '{print $NF}'`
        if [ ${#ZK_NODES[@]} -eq 1 ] && [[ "${zk_stus}" != "standalone" ]];then
             echo "zookeeper status is error."
             bash /usr/local/bin/zookeeper/zookeeper/bin/zkServer.sh stop >/dev/null 2>&1
             bash /usr/local/bin/zookeeper/zookeeper/bin/zkServer.sh start >/dev/null 2>&1
        elif [ ${#ZK_NODES[@]} -ne 1 ] && [[ "${zk_stus}" != "follower" ]] && [[ "${zk_stus}" != "leader" ]];then
             echo "zookeeper status is error."
             bash /usr/local/bin/zookeeper/zookeeper/bin/zkServer.sh stop >/dev/null 2>&1
             bash /usr/local/bin/zookeeper/zookeeper/bin/zkServer.sh start >/dev/null 2>&1
        fi
        sleep 60
    done
}

main
