#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
FRAME_INSTALL_DIR="/usr/local/bin/zookeeper"
ZK_NODES=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))
TOOL_PATH="/opt/huawei/dj/tools/services/zookeeper"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
VERSION_PATH="/opt/huawei/dj/versions/"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/zookeeper"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/zookeeper.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install_rsyslog()
{
    local rsyslog_conf_dir="/etc/rsyslog.d/"
    /usr/bin/cp ${CURRENT_PATH}/rsyslog_zookeeper.conf ${rsyslog_conf_dir}
    CHECK_RESULT $? "Copy rsyslog_zookeeper.conf ${rsyslog_conf_dir} failed."
    log_info "Restart rsyslog..."
    service rsyslog restart
    if [[ "$?" != "0" ]];then
        # repeating "systemctl restart xxx" over 6 times in 10 seconds will cause
        # error(start of the service was attempted too often) by default.
        sleep 10
        service rsyslog restart
    fi
}

function install_zookeeper()
{
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cli_tools/*  ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege ${TOOL_PATH}
    create_link ${TOOL_PATH}/zookeeperControl.sh
    log_info "Copy scripts to ${TOOL_PATH} finished."

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/zookeeper.ver ${VERSION_PATH}
    setprivilege ${VERSION_PATH}
    log_info "Copy zookeeper.ver to ${VERSION_PATH} finished."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/zookeeper.sh ${INSPECT_SH_PATH}
    setprivilege ${INSPECT_SH_PATH}
    log_info "Copy zookeeper.sh to ${INSPECT_SH_PATH} finished."
}

function set_sudoers_for_zookeeper()
{
    sed -i "/\/zookeeperControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/zookeeper/zookeeperControl.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/set_zk_client_pwd.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/zookeeper/set_zk_client_pwd.sh" >> /etc/sudoers.d/openstack
}

log_info "Begin to install zookeeper..."
deploy_uninstall_script
install_zookeeper
install_rsyslog
set_sudoers_for_zookeeper
log_info "Install zookeeper finished."
