#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"


function main()
{
    log_info "Begin to start zookeeper"
    fail_count=0
    while [ ${fail_count} -lt 10 ]
    do
        zookeeperControl -A RESTART
        if [ $? -eq 0 ];then
            log_info "Start zookeeper finished."
            exit 0
        fi
        let ++fail_count
        log_info "Start zookeeper failed, fail_count=${fail_count}."
        sleep 30
    done
    log_info "Start zookeeper failed."
    exit 1
}
main
