#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
version=$(read_microservice_ver /opt/huawei/dj/versions/zookeeper.ver)

function stop_service()
{
    log_info "Begin to stop zookeeper..."
    if [[ ! -f /usr/bin/zookeeperControl ]];then
        log_warn "Stop zookeeper failed."
        return 0
    fi
    zookeeperControl -S STOP
    if [[ $? -ne 0 ]];then
        log_warn "Stop zookeeper failed."
        exit 1
    fi
    bash /usr/local/bin/zookeeper/zookeeper/bin/zkServer.sh stop >/dev/null 2>&1
    log_info "Stop zookeeper finished."
}

function uninstall_instance()
{
    #delete container instance
    for i in `seq 1 5`;
    do
        log_info "Begin to delete container instance zookeeper..."
        inst_num=`docker ps -a|grep zookeeper|wc -l`
        if [[ ${inst_num} -lt 1 ]];then
            log_info "There is no container instance zookeeper, skip."
            log_info "Delete container instance zookeeper finished."
            return 0
        else
            docker rm -f zookeeper >/dev/null 2>&1
        fi
    done
}

function uninstall_img()
{
    #delete image
    image_name="zookeeper:${version}"
    log_info "Begin to delete docker image ${image_name}..."
    for i in `seq 1 5`;
    do
        img_num=`docker images -q ${image_name}|wc -l`
        if [[ ${img_num} -gt 0 ]];then
            docker rmi -f zookeeper:${version} >/dev/null 2>&1
        else
            rm -rf /usr/local/bin/zookeeper
            rm -rf /opt/huawei/dj/tools/services/zookeeper
            rm -f  /usr/bin/zookeeperControl
            log_info "Delete docker image ${image_name} finished."
            return 0
        fi
    done
}

function uninstall()
{
    stop_service
    uninstall_instance
    uninstall_img
}

uninstall;ret_val=$?
exit ${ret_val}

