#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/zookeeper_upgrade.log"
CUR_NODE_IDX=$(get_info.py node_index)

##########################################
#
#check upgrade version
#
##########################################
function check_version()
{
    # 不支持以升级的方式安装zookeeper
    if [ ! -f "/opt/huawei/dj/versions/zookeeper.ver" ];then
        echo "-1"
        exit 0
    fi
    is_need_upgrade zookeeper;ret_val=$?
    if [ ${ret_val} -eq 1 ]; then
        echo -1
        exit 0
    fi
}
function check_rollback()
{
    should_rollback read zookeeper
    if [ $? -ne 0 ];then
        log_info "do not need rollback"
        echo "-1"
        exit 0
    fi
}
if [[ $1 != "rollback" ]] && [[ $1 != "upgrade" ]];then
    echo "-1"
    exit 0
fi
if [[ $1 == "upgrade" ]];then
    check_version
    echo ${CUR_NODE_IDX}
fi
if [[ $1 == "rollback" ]];then
    check_rollback
    echo "1"
fi
