#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/zookeeper_upgrade.log"

function rollback_files()
{
    #   The new and old data are mixed together, that is, the epoch is inconsistent with the log,
    #   which will cause the zk cluster to be abnormal, so the new data needs to be cleared.
    rm -rf /opt/huawei/dj/etc/zookeeper/data/*
    rm -rf /var/log/huawei/dj/services/system/zookeeper/version-2/*

    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function rollback_zookeeper_container()
{
    # rollback container
    # 1.停止zookeeper, 2.删除容器镜像,3.回滚镜像,4.启动zookeeper,5.检查zookeeper状态
    cmd_retry "zookeeperControl -S STOP" 120 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "stop zookeeper failed."
        return 1
    fi
    log_info "Stop zookeeper success."
    cmd_retry "docker rm -f zookeeper" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep zookeeper | wc -l`
    if [ ${check_container} -ne 0 ];then
        log_error "Remove container failed."
        return 1
    fi
    log_info "Remove container success."
    new_version=$(read_microservice_ver ${LINE_ROOT}/services/zookeeper/zookeeper.ver)
    remove_image "zookeeper:${new_version}"; CHECK_RESULT $?
    rollback_files; CHECK_RESULT $?
    rollback_image ${CURRENT_DIR}/backup_files/ "zookeeper"
    if [ $? -ne 0 ];then
        log_error "Error to rollback zookeeper image."
        return 1
    fi
    if [[ "$(get_info.py profile)" == "private_recover" ]];then
        sed -i "s#omm-haControl.*CompontStat.*#return 0#" /opt/huawei/dj/tools/services/zookeeper/zookeeperControl_Servicecheck
        sed -i "s#NODE_NUMBER.*get_info.*#NODE_NUMBER=3#" /opt/huawei/dj/tools/services/zookeeper/zookeeperControl_Servicecheck
        sed -i "s#NODE_NUMBER.*get_info.*#NODE_NUMBER=3#" /opt/huawei/dj/tools/services/zookeeper/zookeeperControl
    fi
    log_info "Rollback zookeeper image success."
    cmd_retry "zookeeperControl -A RESTART" 120 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Start zookeeper failed."
        return 1
    fi
    log_info "Start zookeeper success."
    return 0
}

rollback_zookeeper_container; CHECK_RESULT $?
sed -i '/^zookeeper$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback zookeeper success."
exit 0
