#ifndef __KMC_HW_CALLBACKEX_COMMON_H
#define __KMC_HW_CALLBACKEX_COMMON_H
#include "signer_common.h"

/*#####################################
 * 以下用到的sig_str_t结构体结构如下，定义在signer_common.h（不用去查看），
为了方便阅读者使用本回调，在此贴出其定义：

typedef struct sig_str_s {
    char*           data;
    unsigned int    len;
} sig_str_t;
#####################################*/

/*#####################################
 * KMC初始化硬件回调时需要传入的参数结构
即（HwInitKeyMgr函数中的 const void *passthroughData），用于KMS认证鉴权
#####################################*/
typedef struct kmc_sig_params_s {
    sig_str_t AK;
    sig_str_t SK;
    sig_str_t host;
    sig_str_t projectID;
} kmc_sig_params_t;

typedef struct mul_login_info_s {
	/* credential parameters */
    sig_str_t AK;
    sig_str_t SK;
    /* HTTP request parameters */
    sig_str_t uri_prefix;
    sig_str_t host;
} mul_login_info_t;

/*#####################################
 * KMC初始化硬件回调时需要传入的参数结构即（HwInitKeyMgr函数中的 void *userData，同时也是KMC中结构体KmcCbbCtx中的void *userData），用于后续KMS认证鉴权。
 变量userData需要由上传组件（需要注册硬件回调函数的组件）初始化，然后传入KMC，由KMC传入硬件回调中
 @  login_info：需要回调函数申请内存的变量，仅供硬件回调函数操作，上层组件不可对其进行更改，使用硬件回调必不可少的参数。
 @  其它参数：用户可在本结构体内自定义添加更多自定义参数，回调函数只操作LoginInfo
#####################################*/
typedef struct UserDataTag {

    mul_login_info_t login_info;
    int skip_ssl_vertify;
    /*可在此处添加更多自定义参数*/
    //自定义参数定义
} user_data_t;



#endif /* __KMC_HW_CALLBACKEX_COMMON_H */