/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2018-2018. All rights reserved.
 * Description: ʹùƽ̨ͳһļӽܿɿԵõĽӿ,
 *              1)ù˾KMCʵԿAESԳƼӽ
 *              2)ʵRSAǶԳƼӽܹ
* Notes: **ָںóɹɵͷڴ棬òɹʵֺͷڴ
 * Author: f00178233
 * Create: 2018-10-08
 */

#ifndef SC_CRYPTOAPI_H
#define SC_CRYPTOAPI_H

#include "sc_type.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef SC_OS_WINDOW
#define SC_DLL_EXPORT  __declspec(dllexport)
#else
#define SC_DLL_EXPORT
#endif


/*****************************************************************************
 :ȡļʼ
 עӽʵָȫ,ܲԤļ
           ļ·÷·ļȨ޲㣻
		   ʼʧܣɲ鿴\include\errorcode.hλ鿴־ļ
		   ʼ־ǰʧܣִͨ export SCC_LOG=/tmp/scc.log óʼ־ļ
*****************************************************************************/
SC_DLL_EXPORT int SCC_Initialize(char *sccCfgFile);

/*****************************************************************************
 : ʹʼ
 ע·÷·ļȨ޲㣻
*****************************************************************************/
SC_DLL_EXPORT int SCC_InitializeWithConfig(configuration *config);

/*****************************************************************************
 :ͷڲʹõڴ
 עҪInitializeɶԳ
*****************************************************************************/
SC_DLL_EXPORT int SCC_Finalize();

/*****************************************************************************
 :ȡKMCļĵĳ
 עKMCܷʽЧ
*****************************************************************************/
SC_DLL_EXPORT int SCC_GetCipherDataLen(int plainTextLen, int *cipherTextLen);

/*****************************************************************************
 :ָdomainʱļӽܣĬdomain 0
 ע
*****************************************************************************/
SC_DLL_EXPORT void SCC_ResetDomain();

/*****************************************************************************
 :ָdomainʱļӽܣʹõdomain
 עһڲлdomainʹóҪڼӽʱָdomain
*****************************************************************************/
SC_DLL_EXPORT void SCC_SetDomain(int domainID);

/*****************************************************************************
 :ܺSetDomain/Ĭ/ָdomainKeyм
 ע:Ƶл domain ӽܽEncryptByDomain
 :  algorithmId ָ㷨м
        domainID ָdomainkeyм
        plainTextʾڴ
       plainTextLenʾĳ
 : cipherText ʾҪɼܺĵڴ飬ָ룬ɵͷڴ
        cipherTextLenʾܺĵʵʳ
 ֵ: SEC_SUCCESS: ɹ
       : ʧ
*****************************************************************************/
SC_DLL_EXPORT int SCC_Encrypt(const char *plainText, int plainTextLen, char **cipherText, int *cipherTextLen);

SC_DLL_EXPORT int
SCC_EncryptByDomain(int domainID, const char *plainText, int plainTextLen, char **cipherText, int *cipherTextLen);

SC_DLL_EXPORT int
SCC_EncryptByAlgorithm(int algorithmID, const char *plainText, int plainTextLen, char **cipherText, int *cipherTextLen);

SC_DLL_EXPORT int
SCC_EncryptByAlgorithmDomain(int algorithmID, int domainID, const char *plainText, int plainTextLen, char **cipherText,
                             int *cipherTextLen);

/*****************************************************************************
 :ܺSetDomain/Ĭ/ָdomainKeyн
 ע:Ƶл domain ӽܽDecryptByDomain
 :  domainID ָdomainkeyн(KMCkey HashֵȷԿʵδʹdomainID)
        cipherTextʾڴ
        cipherTextLenʾĵ볤
 : plainText ʾܺڴ飬ɵͷڴ
       plainTextLenʾܺڴĳ
 ֵ:  SEC_SUCCESS: ɹ
          : ʧ
*****************************************************************************/
SC_DLL_EXPORT int SCC_Decrypt(const char *cipherText, int cipherTextLen, char **plainText, int *plainTextLen);

SC_DLL_EXPORT int
SCC_DecryptByDomain(int domainID, const char *cipherText, int cipherTextLen, char **plainText, int *plainTextLen);

/*****************************************************************************
 :ܺ¼ܺþԿܺSetDomain/Ĭ/ָkey
 ע:Ƶлdomain ӽܽReEncryptByDomain
*****************************************************************************/
SC_DLL_EXPORT int SCC_ReEncrypt(const char *cipherText, int cipherTextLen, char **newCipherText, int *newCipherTextLen);

SC_DLL_EXPORT int SCC_ReEncryptByDomain(int domainID, const char *cipherText, int cipherTextLen, char **newCipherText,
                                        int *newCipherTextLen);

SC_DLL_EXPORT int
SCC_ReEncryptByAlgorithm(int algorithmID, const char *cipherText, int cipherTextLen, char **newCipherText,
                         int *newCipherTextLen);

SC_DLL_EXPORT int
SCC_ReEncryptByAlgorithmDomain(int algorithmID, int domainID, const char *cipherText, int cipherTextLen,
                               char **newCipherText,
                               int *newCipherTextLen);
/*****************************************************************************
 :Կkeystoreļ
 ע:
*****************************************************************************/
SC_DLL_EXPORT int SCC_GenNewKeyFile(const char *toFile);

/*****************************************************************************
 :keystoneļָļڱԿļ
 ע:
 : toFileʾļ
       pwdʾ
        pwdLenʾ
 : 
 ֵ: SEC_SUCCESS: ɹ
         : ʧ
*****************************************************************************/
SC_DLL_EXPORT int SCC_ExportKey(const char *toFile, const char *pwd, int pwdLen);
/*****************************************************************************
 : ָkeystoneļMKݣڻָԿļ
 : fromFileʾҪkeystoneļ
       pwdʾ
       pwdLenʾ
 : 
 ֵ: SEC_SUCCESS: ɹ
         : ʧ
*****************************************************************************/
SC_DLL_EXPORT int SCC_ImportKey(const char *fromFile, const char *pwd, int pwdLen);

/*****************************************************************************
 :ɹ˽ԿԣҪڸԿ
 ע:״λȡԿʱԶɹ˽Կ
          ǰ汾øǾԿʽԹ˽Կڳ־û
*****************************************************************************/
SC_DLL_EXPORT int SCC_ResetRSAKey();

/***************************************************************************************************************
 :ʵַǰȫ֤ͨͨϢ
 ע:Զ˻ȡԿڱԶ˼ܺȻĴݵԶ˽Կ
 ===============================================================================================================
 * Modified by l00403032: added identifier "const" to parameter "publicKey" of SCC_PublicKeyEncrypt funciton.
 * 2019-11-18
***************************************************************************************************************/
SC_DLL_EXPORT int SCC_GetPublicKey(char **key);

SC_DLL_EXPORT int
SCC_PublicKeyEncrypt(const char *plainText, const int plainTextLen, const char *publicKey, char **cipherText,
                     int *cipherTextLen);

SC_DLL_EXPORT int
SCC_PrivateKeyDecrypt(const char *cipherText, const int cipherTextLen, char **plainText, int *plainTextLen);

/*****************************************************************************
 :ָdomain µԿ
 ע:1.Ĭdomain 0״ʹԶԿøú
          2.0ڲkeydomain״ʹҪøúԳʼʱGetMaxMkIDжǷkey
		  3.ڲMaster KeyɷʽKMCKMC_MK_GEN_BY_IMPORTģ,δʹKMC_MK_GEN_BY_INNER
		  4.µkey,ɾʷkey,Keystoreļdomainۼ洢MKΪ4096,Ҫ滮üƵ
*****************************************************************************/
SC_DLL_EXPORT int SCC_ActiveNewKey(int domainID);

/*****************************************************************************
 :ɾdomainзǼkeykeyֵе
 ע:1. Keystoreļdomainۼ洢MKΪ4096
          2. ҵֱֹӵøú
*****************************************************************************/
SC_DLL_EXPORT int SCC_ClearInactiveKey(int domainID);

SC_DLL_EXPORT int SCC_GenSecKey(int keyLen, char **key, int *keyBase64Len);

SC_DLL_EXPORT int SCC_GenSecByteKey(int keyLen, char **key);

/*****************************************************************************
 :ָdomain ⲿעµԿ
 ע:1.Ĭdomain 0ΪԶԿ޷øúע
          2.0domainⲿעkey,״μǰҪøú
		  3.keyID0ʾԶȡKeyID+1ΪµKeyID
		  4.ʼʱGetMaxMkIDжǷkeyIsExistMkIDжǷkeyIDkeyIDѴ
		  5.ڲMaster KeyɷʽKMCKMC_MK_GEN_BY_IMPORTģ,δʹKMC_MK_GEN_BY_INNER
		  6.µkey,ɾʷkey,Keystoreļdomainۼ洢MKΪ4096,Ҫ滮üƵ
 ==============================================================================================================================
 * Modified by l00403032: added identifier "const" to parameter "base64Key" and "key" of SCC_RegisterKey and SCC_RegisterByteKey funcitons.
 * 2019-11-18
*****************************************************************************/
SC_DLL_EXPORT int SCC_RegisterKey(int domainID, int keyID, const char *base64Key, int base64KeyLen);

SC_DLL_EXPORT int SCC_RegisterByteKey(int domainID, int keyID, const char *key, int keyLen);

/*****************************************************************************
 :ȡָdomainkey IDԿⲿмӽܣʵչ
 ע:1.ҪԿϢ 
          2. keyID<=0ʱصǰdomain Active Key
*****************************************************************************/
SC_DLL_EXPORT int SCC_GetKeyByID(int domainID, int keyID, char **key, int *keyLen, int base64Ind);

SC_DLL_EXPORT int SCC_GetKeyByIDEx(int domainID, int keyID, char **key, int *keyLen, int base64Ind);

/*****************************************************************************
 :ڶλ⣬鿴Keystoreڲdomain,RootKey,MasterKey
 ע:1.־ļ
*****************************************************************************/
SC_DLL_EXPORT void SCC_PrintAllInfoToLog();

/*****************************************************************************
 :ȡָdomainǰkeyID,жϸdomainǷʼkey
 ע:maxKeyIDΪ0 ʾdomainδʼkey 
*****************************************************************************/
SC_DLL_EXPORT int SCC_GetMaxMkID(int domainID, int *maxKeyID);

SC_DLL_EXPORT int SCC_GetMaxMkIDEx(int domainID, int *maxKeyID);

/*****************************************************************************
 :жָdomainǷָkeyID,ڱظkey.
 ע:result type.hͷļSEC_FALSE(0)ʾڣSEC_TRUE (1)ʾ
*****************************************************************************/
SC_DLL_EXPORT int SCC_IsExistMkID(int domainID, int keyID, int *result);

SC_DLL_EXPORT int SCC_IsExistMkIDEx(int domainID, int keyID, int *result);

/*****************************************************************************
 : Կʱڸ¸ԿԶ̸ͬһKeyļĳá
*****************************************************************************/
SC_DLL_EXPORT int SCC_UpdateRootKey();

/*****************************************************************************
 :  ãKeystoreļɾʹÿֵдkeystoreļȻɾļ
 ɾkeystore޷ԭڴеԿҲɾʹøúĳʱҪԿʱ
*****************************************************************************/
SC_DLL_EXPORT int SCC_SecureEraseKeystore();

/*****************************************************************************
 :  ͷڴ档Windowsµcδṩfreeӿ
*****************************************************************************/
SC_DLL_EXPORT void SCC_Free(void *ptr);

/*****************************************************************************
 : ⲿӿںʹָ㷨hash
            óɹhashCodeҪͷ
*****************************************************************************/
SC_DLL_EXPORT int SCC_CreateHashCode(int algorithmId, const char *plainText, int plainTextLen, char **hashCode, int *hashCodeLen);

/*****************************************************************************
 : ⲿӿںʹָ㷨֤hashcode
*****************************************************************************/
SC_DLL_EXPORT int SCC_CheckHashCode(int algorithmId, const char *plainText, int plainTextLen, const char *cmpHashCode, int hashCodeLen, int *checkRet);

/*****************************************************************************
 : ⲿӿںʹָ㷨domainkeyhmac hash
            óɹhmacDataҪͷ
*****************************************************************************/
SC_DLL_EXPORT int SCC_CreateHmacCode(int algorithmId, int domain, const char *plainText, int plainTextLen, char **hmacData, int *hmacDataLen);

/*****************************************************************************
 : ⲿӿںʹָdomainkey֤hmac hashcode
*****************************************************************************/
SC_DLL_EXPORT int SCC_CheckHmacCode(int domain, const char *plainText, int plainTextLen, const char *hmacData, int hmacDataLen, int *checkRet);

/*****************************************************************************
 : ⲿӿںʹָ㷨domainkeyļhmac hash
            óɹhmacDataҪͷ
*****************************************************************************/
SC_DLL_EXPORT int SCC_CreateFileHmacCode(int algorithmId, int domain, const char *file, char **hmacData, int *hmacDataLen);

/*****************************************************************************
 : ⲿӿںʹָdomainkey֤ļhashcode
*****************************************************************************/
SC_DLL_EXPORT int SCC_CheckFileHmacCode(int domain, const char *file, const char *hmacData, int hmacDataLen, int *checkRet);

/*****************************************************************************
 : ⲿӿںʹָ㷨hash
            óɹcipherTextҪͷ
*****************************************************************************/
SC_DLL_EXPORT int SCC_ProtectPwd(int algorithmId, const char *plainText, int plainTextLen, char **cipherText, int *cipherTextLen);

/*****************************************************************************
 : ⲿӿں֤hashcode
*****************************************************************************/
SC_DLL_EXPORT int SCC_VerifyPwd(const char *plainText, int plainTextLen, const char *cipherText, int cipherTextLen, int *checkRet);

/*****************************************************************************
 :ĬdomainΪ0
*****************************************************************************/
#define DEFAULT_DOMAIN 0
/*****************************************************************************
 :32byteʾ256bit
*****************************************************************************/
#define KEY_DEFAULT_LEN 32
#define KEY_MIN_LEN 16
#define KEYLIFE_DEFAULT_DAYS 180

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif
