/*******************************************************************************
* Copyright @ Huawei Technologies Co., Ltd. 1998-2014. All rights reserved.
* File name:  WSEC_Type.h
* Decription:
     Ͷ
*********************************************************************************/
#ifndef SC_CSCTYPE_H
#define SC_CSCTYPE_H

#ifdef __cplusplus
extern "C"
{
#endif

/************************************************************************
 *  type defines for certsign component
***********************************************************************/

typedef enum {
    CERT_FORMAT_PEM = 0,   /*PEM_PKCS8 format*/
    CERT_FORMAT_PEMRSA,   /*PEM_PKCS1 format */
    CERT_FORMAT_ASN1     /* ASN.1/DER */
} CertFormat;

typedef enum {
    DIGEST_SHA256 = 0,
    DIGEST_SHA384,
    DIGEST_SHA512
} DigestID;

typedef enum {
    KEY_ALGORITHM_TYPE_RSA = 0,
    KEY_ALGORITHM_TYPE_EC
} KeyAlgIDType;

typedef enum {
    ALG_AES256 = 0
} EncryptAlgID;

typedef enum {
    KEY_RSA2048 = 0,
    KEY_RSA4096,
    KEY_EC256,
    KEY_EC384
} KeyAlgID;

typedef enum {
    ALT_TYPE_EMAIL = 0, //email: email address
    ALT_TYPE_URI, //URI: uniform resource indicator
    ALT_TYPE_DNS, //DNS: domain name
    ALT_TYPE_RID, //RID: registered ID: OBJECT IDENTIFIER
    ALT_TYPE_IP, //IP: IP address
    ALT_TYPE_OTHERNAME //otherName
} SubjectAltType;

typedef struct csc_KeyPair {
    char *priKey;
    char *pubCsrCertKey;// public key or csr key or certificte key
    char *passwd;
    char *keyId;
    int priKeyLen;
    int pubCsrCertLen;
    int keyFormat;
    int signAlgorithm; //Only use by sign internal function 
} CSCKeyPair;


typedef struct csc_CallBackParm {
    void *contextParm1; //env
    void *contextParm2; //keyMgr
    void *contextParm3; //caKeyBean
} CSCCallBackParm;

typedef struct csc_SignCallBackOp {
    CSCCallBackParm *contextParm;

    int (*SignData)(CSCCallBackParm *cbParm, CSCKeyPair caKeyInfo, unsigned char *signData, int dataLen,
                    unsigned char **signResult, int *resultLen);
} CSCSignCallBackOp;

typedef struct csc_Subject {
    char *subject;
    char *countryName;
    char *stateOrProvinceName;
    char *localityName;
    char *organizationName;
    char *organizationalUnitName;
    char *emailAddress;
    char *commonName;
} CSCCertSubject;

typedef struct csc_Extensions {
    char *basicConstraints;
    char *crlDistributionPoints;
    char *subjectAltName;
    char *keyUsage;
    char *authorityInfoAccess;
} CSCCertExtensions;

typedef struct csc_CertSignInfo {
    char *serialNo;
    char *notBefore;
    char *notAfter;
    int serialSeq;
    int days;
    int digestID;
} CSCCertSignInfo;

typedef struct csc_CertInfo {
    CSCCertSignInfo *signinfo;
    CSCCertSubject *subj;
    CSCCertExtensions *exts;
    CSCKeyPair *key;
} CSCCertInfo;

typedef struct csc_CertData {
    char *data;
    int len;
} CSCCertData;

typedef struct csc_CSRInfo {
    CSCCertSignInfo *signinfo;
    CSCCertExtensions *exts;
    char *csrKey;
} CSCCSRInfo;

typedef struct csc_CrlCert {
    char *serialNo;
    char *revokeTime;
    int revokeReason;
} CSCCrlCert;

typedef struct csc_CrlSignInfo {
    char *serialNo;
    CSCCrlCert *crlCertArray;
    int crlCertCount;
    int serialSeq;
    int days;
    int digestID;
    int outformat;
} CSCCrlSignInfo;


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif/* SC_CSCTYPE_H */
