#ifndef __PWDPOLICYAPI_H__
#define __PWDPOLICYAPI_H__

#include "sc_type.h"
#include "sc_errcode.h"

#ifdef __cplusplus
extern "C" {
#endif
//GetPolicy policy int鳤
#define POLICY_LEN_COUNT 5

typedef enum ppc_VerifyPolicyResult {
    RESULT_SUCCESS = 0,
    RESULT_FAIL_LESS_MINLEN,
    RESULT_FAIL_OVER_MAXLEN,
    RESULT_FAIL_LESS_CLASSMINLEN,
    RESULT_FAIL_INVALID_SPECCHAR,
} VerifyPolicyResult;

/*****************************************************************************
 : ⲿӿں,жϿǷ
*****************************************************************************/
int PPC_IsMatchPolicy(const char *pwd, const int policyId, const int verifySpecCharInd, int *matchResult);

/*****************************************************************************
 : ⲿӿں,жǷΪǿ
*****************************************************************************/
int PPC_IsStrongPwd(const char *pwd, int *strongInd);

/*****************************************************************************
 : ⲿӿں,жǷΪ
*****************************************************************************/
int PPC_IsWeakPwd(const char *pwd, int *weakInd);

/*****************************************************************************
 : ⲿӿں,ȫ,pwdLenĬֵΪ⻧Զ峤ȣpwdLenС6ԶΪ³6
*****************************************************************************/
int PPC_GenSecPwd(const char specChars[], char **passwd, int *pwdLen);

/*****************************************************************************
 : ⲿӿں,ͨԲָPolicyȲȫ
*****************************************************************************/
int PPC_GenSecPwdByPolicy(int policyId, char **passwd, int *pwdLen);

/*****************************************************************************
 : ⲿӿں,ĬԲָPolicyȲȫ
*****************************************************************************/
int PPC_GenDefaultSecPwd(char **passwd, int *pwdLen);

/*****************************************************************************
 : ⲿӿں,ͨIDȡԣ
lenArrayɵÿͻṩռ
 lenArray[0]=minlen
 lenArray[1]=maxlen
 lenArray[2]=minclass
 lenArray[3]=allowminlen
 lenArray[4]=allowminclass
constָspecCharsҪ÷ͷڴ
*****************************************************************************/
int PPC_GetPolicy(int policyId, int *lenArray, int arraySize, const char **specChars);

/*****************************************************************************
 : ʼ,
 ppcCfgFile־زΪnullַ־
 timerStartInd ڷһֱеķļ¼ٵĶʱ,timerStartInd=0,timerStartInd=1
 weakPwdUseInd УĳweakPwdUseInd=0,weakPwdUseInd=1
*****************************************************************************/
int PPC_Initialize(char *ppcCfgFile, int timerStartInd, int weakPwdUseInd);

/*****************************************************************************
  :  ⲿӿں:ͷڲʹõڴ
*****************************************************************************/
int PPC_Finalize();

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  // __PWDPOLICYAPI_H__