#ifndef __SIGNER_COMMON_H
#define __SIGNER_COMMON_H
#include <stddef.h>
typedef struct sig_str_s {
    char*           data;
    unsigned int    len;
} sig_str_t;

int sig_empty_str(const sig_str_t* str);

void sig_trim_str(sig_str_t* str, sig_str_t* dst);

int sig_sprintf(char* buf, const char* fmt, ...);

int sig_snprintf(char* buf, unsigned int n, const char* fmt, ...);

size_t sig_unescape(char *dst, char *s, size_t size);

#define SIG_ESCAPE_URI 1
#define SIG_ESCAPE_QUERY 2
size_t sig_escape(char *d, char *src, size_t size, int type);

#define sig_str(s) {.data=(s),.len=strlen(s)}
#endif /* __SIGNER_COMMON_H */
