#!/usr/bin/python

import ctypes
import threading

SEC_SUCCESS=0
SEC_TRUE = 1
SEC_FALSE = 0
DEFAULT_POLICY_ID = 0
PWD_LEN_AUTO_GET = 0
POLICY_LEN_ARRAY_SIZE=5
MATCH_POLICY_RESULT_SUCCESS = 0
gInitFlag=False
lock=threading.Lock()

class PwdpolicyAPI(object):
    class PwdPolicy:
       minlen=8
       maxlen=32
       minclass=3
       allowminlen=6
       allowminclass=2
       specialchar="`~!@#$%^&*()-_=+\\|[{}];:'\",<.>/?"
     
    def __init__(self):
        self.pdll = ctypes.cdll.LoadLibrary('/usr/local/seccomponent/lib/libsc-pwdpolicy.so')

    def encode(self, value):
        if isinstance(value, bytes):
            return value
        else:
            return value.encode('ascii')

    def decode(self, value):
        if isinstance(value, bytes):
            return value.decode()
        else:
            return value

    def initialize(self, confFile, timerStartInd, weakPwdUseInd):
        result = None
        if confFile is None:
            raise Exception('initialize input confFile is None.')
        else:
            confFileAsc = self.encode(confFile)
            try: 
                lock.acquire()
                timerStart=SEC_FALSE;
                weakPwdUse=SEC_FALSE;
                if timerStartInd:
                    timerStart=SEC_TRUE
                
                if weakPwdUseInd:
                    weakPwdUse=SEC_TRUE
            
                result = self.pdll.PPC_Initialize(confFileAsc,timerStart,weakPwdUse)
            except Exception as e:
                raise Exception('Initialize Failed. Exception=' + e )
            finally:
                lock.release()
                if result == SEC_SUCCESS:
                  pass
                elif result == 1001:
                  raise Exception('Initialize  Failed. Error=ERR_NO_INIT,ErrCode=' + str(result))
                elif result == 1002:
                  raise Exception('Initialize  Failed. Error=ERR_REPEAT_INIT,ErrCode=' + str(result))
                elif result == 1003:
                  raise Exception('Initialize  Failed. Error=ERR_INIT_SYS_LOG_FAIL,ErrCode=' + str(result))
                elif result == 1004:
                  raise Exception('Initialize  Failed. Error=ERR_INIT_LOG_FAIL,ErrCode=' + str(result))
                elif result == 1005:
                  raise Exception('Initialize  Failed. Error=ERR_INIT_CFG_FAIL,ErrCode=' + str(result))
                elif result == 3001:
                  raise Exception('Initialize  Failed. Error=SEC_ERR_INIT_WEAKPWD_FAIL,ErrCode=' + str(result))
                elif result == 3002:
                  raise Exception('Initialize  Failed. Error=SEC_ERR_INIT_TIMER_FAIL,ErrCode=' + str(result))
                elif result == 3003:
                  raise Exception('Initialize  Failed. Error=SEC_ERR_INIT_MONITOR_FAIL,ErrCode=' + str(result))
                elif result == 3004:
                  raise Exception('Initialize  Failed. Error=SEC_ERR_INIT_DATA_FAIL,ErrCode=' + str(result))
                else:
                  raise Exception('Initialize  Failed. ErrCode=' + str(result))
        return result

    def finalize(self):
        result = None
        try: 
            lock.acquire()
            result = self.pdll.PPC_Finalize()
            global gInitFlag
            gInitFlag=False
        except Exception as e:
            raise Exception('finalize  Failed. Exception=' + e )
        finally:
            lock.release()
            if result != SEC_SUCCESS:
               raise Exception('finalize  Failed. result=' + str(result))
        return result

    def isWeakPwd(self, password):
        result = None
        weakPwdResult = False
        if password is None:
            raise Exception('input password is None.')
        else:
            passwordAsc = self.encode(password)
            checkResult = ctypes.c_int()
            p_checkResult = ctypes.pointer(checkResult)
            try: 
                result=self.pdll.PPC_IsWeakPwd(passwordAsc,p_checkResult)
            except Exception as e:
                raise Exception('call isWeakPwd Failed. Exception=' + str(e) )
            finally:
                if result == SEC_SUCCESS:
                    if checkResult.value  == SEC_TRUE:
                       weakPwdResult=True;
                else:
                    raise Exception('call isWeakPwd failed. result=' + str(result))
        return weakPwdResult

    def isStrongPwd(self, password):
        result = None
        strongPwdResult = False
        if password is None:
            raise Exception('input password is None.')
        else:
            passwordAsc = self.encode(password)
            checkResult = ctypes.c_int()
            p_checkResult = ctypes.pointer(checkResult)
            try: 
                result=self.pdll.PPC_IsStrongPwd(passwordAsc,p_checkResult)
            except Exception as e:
                raise Exception('call isStrongPwd Failed. Exception=' + str(e) )
            finally:
                if result == SEC_SUCCESS:
                    if checkResult.value  == SEC_TRUE:
                       strongPwdResult=True;
                else:
                    raise Exception('call isStrongPwd failed. result=' + str(result))
        return strongPwdResult
        
    def isMatchPolicy(self, password,policyId=DEFAULT_POLICY_ID, verifySpecCharInd=SEC_TRUE):
        result = None
        weakPwdResult = False
        if password is None:
            raise Exception('input password is None.')
        else:
            passwordAsc = self.encode(password)
            checkResult = ctypes.c_int()
            p_checkResult = ctypes.pointer(checkResult)
            try: 
                result=self.pdll.PPC_IsMatchPolicy(passwordAsc,policyId,verifySpecCharInd,p_checkResult)
            except Exception as e:
                raise Exception('call isMatchPolicy Failed. Exception=' + str(e) )
            finally:
                if result == SEC_SUCCESS:
                    if checkResult.value  == MATCH_POLICY_RESULT_SUCCESS:
                       weakPwdResult=True;
                else:
                    raise Exception('call isMatchPolicy failed. result=' + str(result))
        return weakPwdResult
        
    def genSecPwd(self, policyId=DEFAULT_POLICY_ID, pwdLen=PWD_LEN_AUTO_GET):
        result = None
        pwdText = None
        
        secPwd = ctypes.c_char_p()
        secPwd_len = ctypes.c_int(pwdLen)
        p_secPwd = ctypes.pointer(secPwd)
        p_secPwd_len = ctypes.pointer(secPwd_len)
        try: 
            result=self.pdll.PPC_GenSecPwdByPolicy(policyId,p_secPwd,p_secPwd_len)
        except Exception as e:
            raise Exception('call GenSecPwdByPolicy Failed. Exception=' + str(e) )
        finally:
            if result == SEC_SUCCESS:
                 pwdText = self.decode(secPwd.value)
                 self.pdll.free(secPwd)
            else:
                    raise Exception('call GenSecPwdByPolicy failed. result=' + str(result))
        return pwdText
              
    def getPolicy(self, policyId=DEFAULT_POLICY_ID):
        result = None
        ppObj=PwdpolicyAPI.PwdPolicy()
        lenArray = (ctypes.c_int*POLICY_LEN_ARRAY_SIZE)()
        lenArray_len = ctypes.c_int()
        specChars = ctypes.c_char_p()
        p_lenArray = ctypes.pointer(lenArray)
        p_lenArray_len = ctypes.pointer(lenArray_len)
        p_specChars = ctypes.pointer(specChars)
        try: 
            result=self.pdll.PPC_GetPolicy(policyId,p_lenArray,POLICY_LEN_ARRAY_SIZE,p_specChars)
        except Exception as e:
            raise Exception('call GetPolicy Failed. Exception=' + str(e) )
        finally:
            if result == SEC_SUCCESS:
                 specCharVals = self.decode(specChars.value)
                 ppObj.minlen=lenArray[0]
                 ppObj.maxlen=lenArray[1]
                 ppObj.minclass=lenArray[2]
                 ppObj.allowminlen=lenArray[3]
                 ppObj.allowminclass=lenArray[4]
                 ppObj.specialchar=specCharVals
                 
            else:
                 raise Exception('call GetPolicy failed. result=' + str(result))
        return ppObj