#!/usr/bin/python
import gzip
import os
import sys
import tarfile
import time
import shutil
import subprocess as commands

PY3 = True

_HCP_ROOT = "/opt/huawei-data-protection/agentproxy/"


def log(content):
    commands.getstatusoutput(
        _HCP_ROOT + "/sbin/log_action.sh log_info 'make_report.py' '" + content + "'")


def ftime():
    return "HCP_Report_%04d_%02d_%02d_%02d_%02d_%02d" % time.localtime()[:6]


def compress(src, dst):
    """compress if the src file is uncompressed"""
    log("compress files:" + src)
    if src[-3:].lower() == ".gz":
        f = open
    else:
        f = gzip.open
        dst = dst + ".gz"
    fopendst = f(dst, 'wb', 9)
    fopensrc = open(src, 'rb')
    fopendst.writelines(fopensrc)
    fopendst.close()
    fopensrc.close()
    return dst


class Failed(object):
    _c = 0

    def __call__(self, text):
        self._c += 1
        sys.stderr.write(text)


def main(*args):
    if len(args) == 0:
        print("Input parameter error!")
        return
    log("begin to collect log files")
    failed = Failed()
    time_base = ftime()
    tmp_path = "/tmp/" + time_base
    base = os.path.join(tmp_path, "DataCollect")
    tarfilepath = "/tmp/DataCollect.zip"
    # compress all files from source folders into destination folders
    log_path = "/var/log/huawei-data-protection/agentproxy/"
    dst_src_paths = [(base + "/logs", _HCP_ROOT + "/logs/AgentProxy"),
                     (base + "/logs/KarborProxy", log_path),
                     (base + "/logs/KarborProxy/ha", log_path + "services/ha/scriptlog"),
                     (base + "/logs/KarborProxy/haproxy", log_path + "services/haproxy"),
                     (base + "/logs/KarborProxy/zookeeper", log_path + "services/zookeeper")
                     ]

    # create folders
    sys.stdout.write("Creating folder: %s\n" % base)
    log("Creating dst folder:" + base)
    os.mkdir(tmp_path)
    os.mkdir(base)
    for dst_path, src_path in dst_src_paths:
        os.mkdir(dst_path)

    done = []
    for dst_path, src_path in dst_src_paths:
        filenames = []
        for _, _, filenames in os.walk(src_path):
            break
        for file in filenames:
            src = os.path.join(src_path, file)
            dst = os.path.join(dst_path, file)
            sys.stdout.write("Compressing: %s\n" % dst)
            try:
                dst = compress(src, dst)
                done.append(dst[len(tmp_path) + 1:])
            except:
                failed("error, skipping: %s\n" % src)

    # create a tar file, and archive all compressed files into ita
    log("create a tar file:" + tarfilepath + ", and archive all compressed files into it")
    tar = tarfile.open(tarfilepath, 'w')
    os.chdir(tmp_path)
    for filename in done:
        try:
            tar.add(filename)
            sys.stdout.write("Adding to tar: %s\n" % filename)
        except:
            failed("error, skipping: %s\n" % filename)
    tar.close()
    log("Delete temp folder" + tmp_path)
    ret = commands.getstatusoutput("chown -h dpamanager:agentproxy %s" % tarfilepath)
    if ret[0] != 0:
        log("chown error")
    ret = commands.getstatusoutput("chmod 770 %s" % tarfilepath)
    if ret[0] != 0:
        log("chmod error")
    if failed._c:
        log("collect log files done with some errors")
        sys.stdout.write(
            "NOTE: %s files have failed to be included!!!\n" % failed._c)
        shutil.rmtree(tmp_path)
        sys.exit(-1)
    else:
        log("collect log files finish")
        shutil.rmtree(tmp_path)


if __name__ == '__main__':
    main(*sys.argv[1:])
