# -*- coding: UTF-8 -*-
from java.io import File
import os


def execute(dataDict):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli
                         e.g: cliRet = cli.execCmd("showsys")
    Return             : the checkitem is pass;cli source info
    """

    local_up_file = os.path.join(
        os.path.abspath(__file__ + "\\..\\make_report.py"))
    PY_LOGGER.debug("filePath is:" + local_up_file)

    sftp = dataDict.get("SFTP")
    if sftp is None:
        PY_LOGGER.debug("sftp is empty")

    ssh = dataDict.get("SSH")
    username = ssh.execCmd("whoami")
    real_user = (username.split('\r\n')[1])
    if real_user != "root":
        PY_LOGGER.debug("Current user is:" + real_user)
        return '', dict(flag=False, des="User not right,please use root user!")

    ssh.execCmd(
        "mkdir -p /opt/huawei-data-protection/agentproxy/inspect/scripts")
    ssh.execCmd(
        "rm -rf /opt/huawei-data-protection/agentproxy/inspect/scripts/*")

    PY_LOGGER.debug("Upload make_report.py to remote")

    device_dir = "/opt/huawei-data-protection/agentproxy/" \
                 "inspect/scripts/make_report.py"
    sftp.putFullPathFileOfSignVerfy(File(local_up_file), device_dir, None)

    ssh.execCmd(
        "chmod -R 750 /opt/huawei-data-protection/agentproxy/inspect/scripts;"
        "dos2unix /opt/huawei-data-protection/agentproxy/inspect/scripts/*")

    return True, ""
