#!/bin/bash
export PATH=$PATH:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/root/bin
G_OS_TYPE=""
G_Net_Card=""
G_OS_TYPE=""
G_ROUTE_BAK_FILE=/var/ebackup_bak/inputRoute.bak
function CheckIp()
{
    local ipstr=$1

    echo $ipstr|egrep '^((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])$' >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
       echo "Error:ip($ipstr) is invalid!"
       return 1
    fi
    return 0
}

function checkout_os_type()
{
    if [[ -f "/etc/SuSE-release" ]]; then
        G_OS_TYPE="SuSE"
    fi

    if [[ -f "/etc/euleros-release" ]]; then
        G_OS_TYPE="Euler"
    fi
}

function isExisted()
{
    local desNetwork=$1
    local netMask=$2
    local gateway=$3

    route -n | grep -w "${desNetwork}" | grep -w "${netMask}" | grep -w "${gateway}"
    if [ $? -ne 0 ];then
        return 1
    fi
    G_Net_Card=`route -n | grep -w "${desNetwork}" | grep -w "${netMask}" | grep -w "${gateway}" | awk '{print $8}'`
    return 0
}

function add_route()
{
    local desNetwork=$1
    local gateway=$2
    local netMask=$3

    #0.check ip
    CheckIp ${desNetwork} && CheckIp ${gateway} && CheckIp ${netMask}
    if [ $? -ne 0 ];then
        exit 1
    fi

    #1.check route
    isExisted ${desNetwork} ${netMask} ${gateway}
    if [ $? -eq 0 ];then
        echo "the route is existed!"
        return 0
    fi

    #2.add route
    route add -net ${desNetwork} netmask ${netMask} gw ${gateway}
    if [ $? -ne 0 ];then
        echo "Error:Fail to add the route(via ${gateway} to ${desNetwork})!"     
        return 1
    fi
    
    #3.write route to file
    isExisted ${desNetwork} ${netMask} ${gateway}
    if [ $? -ne 0 ];then
        echo "Error:Fail to add the route(via ${gateway} to ${desNetwork})!"
        return 1
    fi
    
    if [ "${G_OS_TYPE}" == "SuSE" ];then
        local SuseRouteFile="/etc/sysconfig/network/routes"
        echo "${desNetwork} ${gateway} ${netMask} ${G_Net_Card}" >> "${SuseRouteFile}"
    else
        local EulerRouteFile="/etc/sysconfig/network-scripts/route-${G_Net_Card}"
        local index=0

        if [ -f "${EulerRouteFile}" ];then 
            cat "${EulerRouteFile}" | grep "^ADDRESS${index}=" > /dev/null 2>&1
            local existed=$?
            while [ ${existed} -eq 0 ]
            do
                index=$((index+1))
                cat "${EulerRouteFile}" | grep "^ADDRESS${index}=" > /dev/null 2>&1
                existed=$?
            done           
        fi

        echo "ADDRESS${index}=${desNetwork}" >> "${EulerRouteFile}"
        echo "NETMASK${index}=${netMask}" >> "${EulerRouteFile}"
        echo "GATEWAY${index}=${gateway}" >> "${EulerRouteFile}"
    fi

    #4.write route to bak file for rollback_route
    echo "${desNetwork} ${netMask} ${gateway}" > "${G_ROUTE_BAK_FILE}"

    return 0
}

function del_route()
{
    local desNetwork=$1
    local gateway=$2
    local netMask=$3

    #0.check ip
    CheckIp ${desNetwork} && CheckIp ${gateway} && CheckIp ${netMask}
    if [ $? -ne 0 ];then
        exit 1
    fi

    #1.check route
    isExisted ${desNetwork} ${netMask} ${gateway}
    if [ $? -ne 0 ];then
        echo "the route is not existed!"
        return 0
    fi

    #2.delete route
    route del -net ${desNetwork} netmask ${netMask} gw ${gateway}
    if [ $? -ne 0 ];then
        echo "Error:Fail to delelte the route(via ${gateway} to ${desNetwork})!"
        return 1
    fi

    #3.delete route in the file
    isExisted ${desNetwork} ${netMask} ${gateway}
    if [ $? -eq 0 ];then
        echo "Error:Fail to delelte the route(via ${gateway} to ${desNetwork})!"
        return 1
    fi
    if [ "${G_OS_TYPE}" == "SuSE" ];then
        local SuseRouteFile="/etc/sysconfig/network/routes"
        sed  -i '/'$desNetwork'[ ].*'$gateway'[ ].*'$netMask'[ ].*'$G_Net_Card'/'d ${SuseRouteFile}
    else
        local EulerRouteFile="/etc/sysconfig/network-scripts/route-${G_Net_Card}"

        if [ -f "${EulerRouteFile}" ];then
            local index=`cat "${EulerRouteFile}" | grep -A2 -w ${desNetwork} | grep -A1 -w ${netMask} | grep -m1 -w ${gateway} | awk -F "=" '{print $1}'| tr -cd "[0-9]"`
            if [[ ! -z "${index}" ]];then                
                sed -i '/^ADDRESS'$index'/ d' "${EulerRouteFile}"
                sed -i '/^NETMASK'$index'/ d' "${EulerRouteFile}"
                sed -i '/^GATEWAY'$index'/ d' "${EulerRouteFile}"
            fi
        fi
    fi
    return 0
}

function rollback_route()
{
    if [ ! -f "${G_ROUTE_BAK_FILE}" ];then
        return 0
    fi

    local desNetwork=`cat ${G_ROUTE_BAK_FILE} | awk '{print $1}'`
    local netMask=`cat ${G_ROUTE_BAK_FILE} | awk '{print $2}'`
    local gateway=`cat ${G_ROUTE_BAK_FILE} | awk '{print $3}'`

    del_route ${desNetwork} ${gateway} ${netMask}
    ret=$?

    return $ret
}

function main()
{
    local L_OP=$1
    local desNetwork=$2
    local netMask=$3
    local gateway=$4

    local RET=1
    checkout_os_type
    
    if [ "${L_OP}" == "add" ];then
        add_route ${desNetwork} ${gateway} ${netMask}
        RET=$?
    elif [ "${L_OP}" == "delete" ];then
        del_route ${desNetwork} ${gateway} ${netMask}
        RET=$?
    elif [ "${L_OP}" == "rollback" ];then
        rollback_route
        RET=$?
    else 
        echo "Error:parameters are invalid!"
        echo "Please input valid parameters:Operation,DestNetwork,SubnetMask,Gateway"
        RET=1
    fi

    return $RET
}
main $*
exit $?
