/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.base.service;

import com.huawei.lego.core.sdk.base.StaticRmiSocketFactory;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.service.IAppServiceHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.rmi.server.RMIClientSocketFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

public class RemoteAppServiceHelper
implements IAppServiceHelper {
    private static final String LOCALHOST = "127.0.0.1";
    private static final Log LOGGER = LogFactory.getInstance(RemoteAppServiceHelper.class);

    @Override
    public Object query(ApplicationContext bundleContext, ServiceInfo info) {
        RmiProxyFactoryBean factory = new RmiProxyFactoryBean();
        AppInfo appInfo = info.getApp();
        StringBuffer buf = new StringBuffer();
        buf.append("rmi://");
        buf.append(appInfo.getIp());
        buf.append(':');
        buf.append(appInfo.getPort());
        buf.append('/');
        buf.append(appInfo.getAppName());
        buf.append('/');
        buf.append(info.getName());
        factory.setServiceUrl(buf.toString());
        StaticRmiSocketFactory clientFac = new StaticRmiSocketFactory(LOCALHOST, 0);
        factory.setRegistryClientSocketFactory((RMIClientSocketFactory)clientFac);
        try {
            factory.setServiceInterface(Class.forName(info.getInterfaceName()));
            factory.afterPropertiesSet();
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage(e), 200L);
            return null;
        }
        catch (RemoteLookupFailureException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage(e), 200L);
            return null;
        }
        return factory.getObject();
    }

    @Override
    public void register(ApplicationContext bundleContext, AppInfo info) {
    }
}

