/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogUtil {
    private static List<RollingRandomAccessFileAppender> appenderList = new ArrayList<RollingRandomAccessFileAppender>();
    private static final long DEFAULT_FILE_SIZE = 0xA00000L;
    private static final int DEFAULT_FILE_NUM = 10;

    public static void cacheAppender(RollingRandomAccessFileAppender appender) {
        if (null != appender) {
            appenderList.add(appender);
        }
    }

    public static RollingRandomAccessFileAppender getDefaultAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        return (RollingRandomAccessFileAppender)config.getAppender("LEGO_LOG");
    }

    public static Layout getDefaultLayout() {
        RollingRandomAccessFileAppender appender = LogUtil.getDefaultAppender();
        if (null != appender) {
            return appender.getLayout();
        }
        return PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withPattern("%m%n").build();
    }

    public static String getDefaultFile() {
        RollingRandomAccessFileAppender appender = LogUtil.getDefaultAppender();
        if (null != appender && appender.getFileName() != null) {
            return appender.getFileName();
        }
        return "logs/lego.log";
    }

    public static long getDefaultFileSize() {
        return 0xA00000L;
    }

    public static int getDefaultFileNum() {
        return 10;
    }

    public static String getLogFile(String fileName) {
        String filePath = LogUtil.getDefaultFile();
        return VerifyUtil.isEmpty(fileName) ? filePath : filePath.substring(0, filePath.lastIndexOf("/") + 1) + fileName;
    }

    public static String getLogFileName(String fileName) {
        return VerifyUtil.isEmpty(fileName) ? "lego" : fileName.substring(fileName.lastIndexOf("/") + 1);
    }

    public static String getLogPath(String fileName) {
        String filePath = LogUtil.getDefaultFile();
        return filePath.substring(0, filePath.lastIndexOf("/") + 1) + fileName.substring(0, fileName.lastIndexOf("/") + 1);
    }

    public static boolean isAppend() {
        return true;
    }
}

