/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderVolumeTask;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.AvailableZoneInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ImageMetadataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgUpdateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapshotActiveInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeTypeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeUpdateInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.task.ForkJoinPoolManager;
import com.huawei.lego.core.base.thread.Enhancer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;

public class CinderManager
implements ICinderManager {
    private static final Log LOG = LogFactory.getInstance(CinderManager.class);

    @Override
    public List<OpenStackVolume> getVolumes(String regionUuid, String tokenId, String projUuid, String volCgId) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        List volumes = (List)Enhancer.timeSupplier((String)("get all volumes for project " + projUuid), () -> this.getAllVolumeInProject(regionUuid, tokenId, projUuid, volCgId)).get();
        return this.translateVolumes(openstackUuid, regionUuid, tokenId, projUuid, volumes);
    }

    private List<VolumeInfo> getAllVolumeInProject(String regionUuid, String tokenId, String projUuid, String volCgId) {
        List<VolumeInfo> volumesList;
        ServiceEndpointUtil endpointUtil = ServiceEndpointUtil.getInstance();
        String urlStr = endpointUtil.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String url = OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOL_DETAILS.getUri();
        if (!VerifyUtil.isEmpty((String)volCgId)) {
            url = OpenstackEnumDefine.RequestUrl.CINDER_BATCHQUERY_VOL_DETAILS_BY_CG.getUri();
        }
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, url, projId);
        LOG.debug((Object)"Get batch volumes request str=%s , volCgId=%s.", new Object[]{newUrlStr, volCgId});
        try {
            volumesList = this.getOpenStackVolumes(newUrlStr, tokenId, volCgId);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Get openStackVolumes error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        return volumesList;
    }

    private List<VolumeInfo> getOpenStackVolumes(String strUrl, String tokenId, String volCgId) {
        int limitNum = (int)LegoConfig.getInstance().getNumber("volume.query.parallel.quantity.config", 3L);
        ForkJoinPool cinderForkJoinPool = ForkJoinPoolManager.getInstance().createForkJoinPool(limitNum);
        try {
            CinderVolumeTask openStackVolumesTask = new CinderVolumeTask(strUrl, tokenId, volCgId, -1L);
            ForkJoinTask<List<VolumeInfo>> openStackVolumes = cinderForkJoinPool.submit(openStackVolumesTask);
            List<VolumeInfo> list = openStackVolumes.get(5L, TimeUnit.MINUTES);
            return list;
        }
        catch (Exception e) {
            LOG.error((Object)"Query OpenStackVolume error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949735L);
        }
        finally {
            cinderForkJoinPool.shutdown();
        }
    }

    private List<OpenStackVolume> translateVolumes(String openstackUuid, String regionUuid, String tokenId, String projUuid, List<VolumeInfo> volInfolist) {
        ArrayList<OpenStackVolume> list = new ArrayList<OpenStackVolume>();
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List<OpenStackVM> vms = novaMgr.getVms(regionUuid, tokenId, projUuid);
        for (VolumeInfo info : volInfolist) {
            OpenStackVolume vol = this.translateVolume(info, openstackUuid, regionUuid, vms);
            list.add(vol);
        }
        return list;
    }

    @Override
    public VolumeInfo queryVolume(String regionUuid, String tokenId, String projUuid, String volumeId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Query volume,parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOL.getUri(), projId, volumeId);
        LOG.debug((Object)"Get volume request str=%s, volumeId=", new Object[]{newUrlStr, volumeId});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Get volume success.response str=%s, volumeId=%s", new Object[]{respStr, volumeId});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Get volume failed.response string is empty.request str=" + newUrlStr + ".response str=" + respStr + ", volumeId=" + volumeId));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            LOG.error((Object)("Get volume failed.jsonNode is null.request str=" + newUrlStr + ".response str=" + respStr + ", volumeId=" + volumeId));
            return null;
        }
        if (jsonNode.path("volume").isMissingNode()) {
            LOG.error((Object)("Get volume failed.jsonNode do not contain volume json keyword.request str=" + newUrlStr + ".response str=" + respStr + ", volumeId=" + volumeId));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(jsonNode.path("volume").toString(), VolumeInfo.class);
    }

    @Override
    public AsyncTaskResponse createVolume(VolumeCreateInfo volumeInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volumeInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_CREATE_VOL.getUri(), projId);
        String volStr = JsonUtil.beanToJson(volumeInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"volume", (Object)volStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqestJson.toString(), tokenId);
        LOG.info((Object)"CreateVolume response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948406L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (null == jsonNode || jsonNode.path("volume").isMissingNode()) {
            LOG.error((Object)("Bad Request createVolume :" + volumeInfo));
            throw new LegoCheckedException(1073948406L);
        }
        VolumeInfo info = JsonUtil.jsonToBean(jsonNode.path("volume").toString(), VolumeInfo.class);
        if (null == info) {
            LOG.error((Object)("Convert to VolumeInfo return null, str=" + jsonNode.path("volume").toString()));
            throw new LegoCheckedException(0x300001L);
        }
        if (this.isVolumeCreateSuccess(info)) {
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolResponse(regionUuid, tokenId, projUuid, info);
    }

    @Override
    public AsyncTaskResponse deleteVolume(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_DELETE_VOL.getUri(), projId, volumeId);
        LOG.info((Object)"DeleteVolume request str: %s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        LOG.info((Object)"DeleteVolume response str: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.info((Object)"DeleteVolume success.volumeId: %s", new Object[]{volumeId});
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("DeleteVolume failed. request str: " + newUrlStr + "response str: " + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    @Override
    public AsyncTaskResponse reserveVolume(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Failed to reserve volume.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeInfo volume = this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
        if (null == volume) {
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (OpenstackEnumDefine.VolumeStatusE.ATTACHING.getType().equals(volume.getStatus())) {
            response.setSuccess(true);
            return response;
        }
        if (!OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
            response.setSuccess(false);
            return response;
        }
        String message = "{\"os-reserve\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        LOG.debug((Object)"Reserve volume request str: %s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.info((Object)"Reserve volume response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkReserveVolResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Failed to reserve volume.itemNotFound :volumeId=" + volumeId + ", request str: " + newUrlStr + ", response: " + respStr));
            response.setErrorCode("2117645");
        } else {
            LOG.error((Object)("Failed to reserve volume.bad Request reserveVolume :volumeId=" + volumeId + ", request str: " + newUrlStr + ", response: " + respStr));
            response.setErrorCode("3145729");
        }
        return response;
    }

    @Override
    public AsyncTaskResponse unreserveVolume(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Unreserve volume failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeInfo volume = this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
        if (null == volume) {
            LOG.error((Object)("Unreserve volume volume is null.volumeId=" + volumeId));
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (!OpenstackEnumDefine.VolumeStatusE.ATTACHING.getType().equals(volume.getStatus())) {
            LOG.info((Object)"Unreserve volume volume success.Only attaching status can do unreserving operation.volumeId=%s, volume status=%s", new Object[]{volumeId, volume.getStatus()});
            response.setSuccess(true);
            return response;
        }
        String message = "{\"os-unreserve\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        LOG.debug((Object)"ReserveVolume request str: %s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"ReserveVolume response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkUnreserveVolResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("ReserveVolume failed. itemNotFound :" + volumeId + ", request str=" + newUrlStr + ", reponse str=" + respStr));
            response.setErrorCode("2117645");
        } else {
            LOG.error((Object)("ReserveVolume failed.bad Request unreserveVolume :" + volumeId + ", request str=" + newUrlStr + ", reponse str=" + respStr));
            response.setErrorCode("3145729");
        }
        return response;
    }

    @Override
    public AsyncTaskResponse enableVolumeBootable(String volumeId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Enable volume bootable failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeInfo volume = this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
        if (null == volume) {
            LOG.error((Object)("Enable volume bootable failed, volumeId=" + volumeId + ",volume is null"));
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (volume.isBootable()) {
            LOG.info((Object)"Enable volume bootable success, volumeId=%s is bootable", new Object[]{volumeId});
            response.setSuccess(true);
            return response;
        }
        if (!OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
            LOG.error((Object)("Enable volume bootable failed, volumeId=" + volumeId + ",queryed volume status is" + volume.getStatus() + ",not available status"));
            response.setSuccess(false);
            return response;
        }
        String message = "{\"os-set_bootable\":{\"bootable\":true}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        LOG.debug((Object)"Enable Volume Bootable request str: %s, volumeId=%s", new Object[]{newUrlStr, volumeId});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Enable Volume Bootable response: %s, volumeId=%s", new Object[]{respStr, volumeId});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkEnableVolBootableResponse(regionUuid, tokenId, projUuid, volumeId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Enable Volume Bootable faild, itemNotFound,volumeId=" + volumeId + "request str: " + newUrlStr + "response: " + respStr));
            response.setErrorCode("2117645");
        } else {
            LOG.error((Object)("Enable Volume Bootable faild,bad Request enableVolumeBootable,volumeId=" + volumeId + "request str: " + newUrlStr + "response: " + respStr));
            response.setErrorCode("3145729");
        }
        return response;
    }

    @Override
    public void updateVolMetadatas(String regionUuid, String tokenId, String projUuid, String volumeId, Map<String, String> metadataMap) {
        if (VerifyUtil.isEmpty(metadataMap) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)("Update volume metadatas failed.parameter is empty.volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        ServiceEndpointUtil util = ServiceEndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_CREATE_VOL_METADATA.getUri(), projId, volumeId);
        LOG.debug((Object)"Update volume metadatas.volumeId=%s,request str=%s", new Object[]{volumeId, newUrlStr});
        String message = this.makeMetadataStr(metadataMap);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Update volume metadatas.volumeId=%s,respStr str=%s", new Object[]{volumeId, respStr});
        if (VerifyUtil.isEmpty((String)respStr) || !respStr.contains("metadata")) {
            LOG.error((Object)("Update volume metadatas failed.respStr is empty or not contain metadata.volumeId=" + volumeId + ",request str=" + newUrlStr + ",respStr str=" + respStr));
            throw new LegoCheckedException(1073948132L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr).getJSONObject("metadata");
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().equalsIgnoreCase((String)json.get(key))) continue;
            LOG.error((Object)("Update volume metadatas failed.Query.Query metadata(" + (String)json.get(key) + ") is not equal to updated metadata(" + entry.getValue() + ").volumeId=" + volumeId + ",request str=" + newUrlStr + ",respStr str=" + respStr));
            throw new LegoCheckedException(1073948132L);
        }
    }

    private String makeMetadataStr(Map<String, String> metadataMap) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            json.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        JSONObject retJson = new JSONObject();
        retJson.put((Object)"metadata", (Object)json);
        return retJson.toString();
    }

    @Override
    public void deleteVolMetadatas(String regionUuid, String tokenId, String projUuid, String volumeId, String metadataKey) {
        if (VerifyUtil.isEmpty((String)metadataKey) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Delete volume metadata failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceEndpointUtil util = ServiceEndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_DELETE_VOL_METADATA.getUri(), projId, volumeId, metadataKey);
        LOG.debug((Object)"Delete volume metadata.request str=%s, volumeID=%s", new Object[]{newUrlStr, volumeId});
        ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
    }

    @Override
    public List<OpenStackVolumeType> getVolumeTypes(String regionUuid, String tokenId, String projUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Get volume type failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceEndpointUtil util = ServiceEndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOL_TYPES.getUri(), projId);
        LOG.debug((Object)"Get volume type.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Get volume type success:volume response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Get volume type failed.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"volume_types")) {
            LOG.error((Object)("Get volume type failed.bad Request getVolumeTypes.request str=" + newUrlStr + "response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeTypeInfo> volTypeInfoList = JsonUtil.jsonArrayToList(json.getString("volume_types"), VolumeTypeInfo.class);
        ArrayList<OpenStackVolumeType> list = new ArrayList<OpenStackVolumeType>();
        for (VolumeTypeInfo volTypeInfo : volTypeInfoList) {
            OpenStackVolumeType volType = new OpenStackVolumeType();
            volType.setRegionUuid(regionUuid);
            volType.setProjUuid(projUuid);
            volType.setName(volTypeInfo.getName());
            volType.setExtraSpecs(JsonUtil.beanToJson(volTypeInfo.getExtraSpecs()));
            int hashcode = OpenStackCommonUtil.generateHashCode(regionUuid, projUuid, volTypeInfo.getName());
            volType.setUuid(openstackUuid + ":" + hashcode);
            volType.setTopMoUuid(openstackUuid);
            list.add(volType);
        }
        return list;
    }

    @Override
    public List<VolumeTypeInfo> queryVolumeTypes(String regionUuid, String tokenId, String projUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceEndpointUtil util = ServiceEndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOL_TYPES.getUri(), projId);
        LOG.debug((Object)"Get volume type success.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Get volume type success:response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to query volume type.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"volume_types")) {
            LOG.error((Object)("Failed to query volume type.bad Request getVolumeTypes.request str=" + newUrlStr + ",response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonArrayToList(json.getString("volume_types"), VolumeTypeInfo.class);
    }

    @Override
    public List<OpenStackAvailabilityZone> getAzs(String regionUuid, String tokenId, String projUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            LOG.error((Object)"Failed to get AZ list.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceEndpointUtil util = ServiceEndpointUtil.getInstance();
        String urlStr = util.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_AZ.getUri(), projId);
        LOG.debug((Object)"Get AZ list.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.debug((Object)"Get AZ list.response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to get AZ list.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"availabilityZoneInfo")) {
            LOG.error((Object)("Failed to get AZ list.bad Request getAzs.request str=" + newUrlStr + "response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<AvailableZoneInfo> zoneList = JsonUtil.jsonArrayToList(json.getString("availabilityZoneInfo"), AvailableZoneInfo.class);
        ArrayList<OpenStackAvailabilityZone> list = new ArrayList<OpenStackAvailabilityZone>();
        for (AvailableZoneInfo zone : zoneList) {
            OpenStackAvailabilityZone openZone = new OpenStackAvailabilityZone();
            openZone.setRegionUuid(regionUuid);
            openZone.setProjUuid(projUuid);
            openZone.setZoneAvailable(Boolean.valueOf(zone.getZoneState().isAvailable()));
            openZone.setName(zone.getZoneName());
            openZone.setTopMoUuid(openstackUuid);
            int hashcode = OpenStackCommonUtil.generateHashCode(regionUuid, projUuid, zone.getZoneName());
            openZone.setUuid(openstackUuid + ":" + "AZ_" + hashcode);
            list.add(openZone);
        }
        return list;
    }

    private OpenStackVolume translateVolume(VolumeInfo info, String openstackUuid, String regionUuid, List<OpenStackVM> vms) {
        OpenStackVolume vol = new OpenStackVolume();
        if (info == null) {
            LOG.info((Object)"VolumeInfo is null");
            return vol;
        }
        vol.setUuid(openstackUuid + ":" + info.getId());
        vol.setRegionUuid(regionUuid);
        vol.setAz(info.getAvailabilityZone());
        vol.setProjUuid(openstackUuid + ":" + info.getProjectId());
        vol.setName(info.getName());
        vol.setSize(Integer.valueOf(info.getSize()));
        vol.setVolType(info.getVolumeType());
        vol.setSnapShotId(info.getSnapShotId());
        vol.setSourceVol(info.getSourceVol());
        vol.setConsistentGroupId(info.getConsistentcyGroupId());
        vol.setReplicaDriverData(info.getReplicaDriverData());
        vol.setStatus(Integer.valueOf(OpenstackEnumDefine.VolumeStatusE.getStatus((String)info.getStatus()).getValue()));
        vol.setBootable(Boolean.valueOf(info.isBootable()));
        vol.setShareable(info.getShareable());
        vol.setTopMoUuid(openstackUuid);
        vol.setMetadata(info.getMetadata());
        vol.setMulitattach(info.getMultiattach());
        vol.setVolumeImageMetadata(info.getVolumeImageMetadata());
        if (!VerifyUtil.isEmpty((Map)info.getVolumeDriverMetadata())) {
            JSONObject jasonObject = JSONObject.fromObject((Object)info.getVolumeDriverMetadata());
            vol.setVolumeDriverMetadata((Map)jasonObject);
        } else {
            vol.setVolumeDriverMetadata(null);
        }
        List attachInfoList = info.getAttachments();
        JSONArray attachmentArray = new JSONArray();
        List<OpenStackVM> bmsVms = OpenStackCommonUtil.getBmsVms(vms);
        for (VolumeAttachmentInfo attachInfo : attachInfoList) {
            JSONObject attachmentObj = new JSONObject();
            attachmentObj.put((Object)"vmUuid", (Object)(openstackUuid + ":" + attachInfo.getServerId()));
            if (VerifyUtil.isEmpty((String)attachInfo.getDevice())) {
                String volVmUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, attachInfo.getServerId());
                boolean isBmsVolume = OpenStackCommonUtil.isBmsServiceVolume(volVmUuid, bmsVms);
                if (isBmsVolume) {
                    attachmentObj.put((Object)"device", (Object)"NA");
                }
            } else {
                attachmentObj.put((Object)"device", (Object)attachInfo.getDevice());
            }
            attachmentArray.add((Object)attachmentObj);
        }
        vol.setAttachmentStr(attachmentArray.toString());
        return vol;
    }

    private AsyncTaskResponse checkDeleteVolResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    LOG.info((Object)"CheckDeleteVolResponse succeed ,volume id: %s", new Object[]{volumeId});
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VolumeStatusE.DELETING.getType().equals(volume.getStatus())) {
                    LOG.error((Object)("CheckDeleteVolResponse failed.volume status is not excepted, excepted status: deleting, current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                LOG.error((Object)("CheckDeleteVolResponse failed ,volume.getStatus() is " + volume.getStatus() + ", volume id:" + volumeId));
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkReserveVolResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    LOG.error((Object)("Check reserveVolume reponse failed. volume is null.volumeId=" + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolumeStatusE.ATTACHING.getType().equals(volume.getStatus())) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
                    LOG.error((Object)("Volume status is not excepted, excepted status: attaching or available,current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkUnreserveVolResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    LOG.error((Object)("Check reserveVolume reponse failed. volume is null.volumeId=" + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
                    LOG.info((Object)"Check reserveVolume response success. volume is null.volumeId=%s, volume status=%s", new Object[]{volumeId, volume.getStatus()});
                    response.setSuccess(true);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkEnableVolBootableResponse(final String regionUuid, final String tokenId, final String projUuid, final String volumeId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeId);
                if (null == volume) {
                    LOG.error((Object)"Check enable volume bootable failed, volume is null, volumeid=%s", new Object[]{volumeId});
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (volume.isBootable()) {
                    LOG.error((Object)"Check enable volume bootable success, volume bootable status is true , volumeid=%s", new Object[]{volumeId});
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
                    LOG.error((Object)("Check enable volume bootable failed, volume status is not excepted, excepted status: available, current status : " + volume.getStatus() + ", volume id: " + volumeId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVolResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeInfo volumeInfo) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volumeInfo, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeInfo volume = CinderManager.this.queryVolume(regionUuid, tokenId, projUuid, volumeInfo.getId());
                if (null == volume) {
                    LOG.error((Object)("Check create volume failed, volume is null, volumeid=" + volumeInfo.getId()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus())) {
                    if (CinderManager.this.isVolumeCreateSuccess(volume)) {
                        response.setSuccess(true);
                        response.setTaskResult(volume);
                        return true;
                    }
                    LOG.error((Object)("Volume status is available, but driver data is none, current status : " + volume.getStatus() + ", volume id: " + volumeInfo.getId()));
                    return false;
                }
                if (!OpenstackEnumDefine.VolumeStatusE.CREATING.getType().equals(volume.getStatus())) {
                    LOG.error((Object)("Volume status is not excepted, excepted status: available or creating, current status : " + volume.getStatus() + ", volume id: " + volumeInfo.getId()));
                    response.setSuccess(false);
                    response.setErrorCode("1073948406");
                    response.setTaskResult(volume);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean isVolumeCreateSuccess(VolumeInfo volume) {
        return OpenstackEnumDefine.VolumeStatusE.AVAILABLE.getType().equals(volume.getStatus()) && !VerifyUtil.isEmpty((String)volume.getReplicaDriverData()) && !volume.getReplicaDriverData().equalsIgnoreCase("{}");
    }

    @Override
    public AsyncTaskResponse createVolCgSnapShot(VolumeCgSnapShotCreateInfo volCgInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volCgInfo)) {
            LOG.error((Object)"Failed to create volume cg snapshot.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_CREATE_VOLCGSNAPSHOT.getUri(), projId);
        LOG.debug((Object)"Create volume cg snapshot.request str: %s", new Object[]{newUrlStr});
        String volRepCgStr = JsonUtil.beanToJson(volCgInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"cgsnapshot", (Object)volRepCgStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqestJson.toString(), tokenId);
        LOG.info((Object)"CreateVolCgSnapShot response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to create volume cg snapshot.response string is empty.request str: " + newUrlStr));
            throw new LegoCheckedException(1073948914L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"cgsnapshot")) {
            LOG.error((Object)("Failed to create volume cg snapshot.bad Request createVolCgSnapShot :" + volCgInfo + ", request str: " + newUrlStr + ", response: " + respStr));
            throw new LegoCheckedException(1073948914L);
        }
        VolumeCgSnapShotInfo info = JsonUtil.jsonToBean(json.getString("cgsnapshot"), VolumeCgSnapShotInfo.class);
        if (null == info) {
            LOG.error((Object)("Failed to create volume cg snapshot.convert to VolumeCgSnapShotInfo return null, str=" + json.getString("cgsnapshot")));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.VolcgsnapshotStatusE.AVAIABLE.getValue().equals(info.getStatus())) {
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolCgSnapShotResponse(regionUuid, tokenId, projUuid, info);
    }

    private AsyncTaskResponse checkCreateVolCgSnapShotResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeCgSnapShotInfo info) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(info, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgSnapShotInfo volCgSnapShot = CinderManager.this.queryVolCgSnapShot(regionUuid, tokenId, projUuid, info.getId());
                if (null == volCgSnapShot) {
                    LOG.error((Object)"Failed to check create volume cg snapshot.volCgSnapShot is null.");
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolcgsnapshotStatusE.AVAIABLE.getValue().equals(volCgSnapShot.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(volCgSnapShot);
                    return true;
                }
                if (!OpenstackEnumDefine.VolcgsnapshotStatusE.CREATING.getValue().equals(volCgSnapShot.getStatus())) {
                    LOG.error((Object)("Volume status is not excepted, excepted status: available or creating, current status : " + volCgSnapShot.getStatus() + ", volume id: " + info.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(volCgSnapShot);
                    response.setErrorCode("1073948914");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public VolumeCgSnapShotInfo queryVolCgSnapShot(String regionUuid, String tokenId, String projUuid, String volCgSnapShotId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volCgSnapShotId)) {
            LOG.error((Object)"Query volume cg snapshot failed. Query parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOLCGSNAPSHOT.getUri(), projId, volCgSnapShotId);
        LOG.debug((Object)"Query volume cg snapshot.request str: %s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.info((Object)"QueryVolCgSnapShot response str: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to query volume cg snapshot.response string is empty.response str: " + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            return null;
        }
        if (!json.containsKey((Object)"cgsnapshot")) {
            LOG.error((Object)("Failed to query volume cg snapshot.bad Request queryVolConsistencyGroup.request str: " + newUrlStr + ", response str: " + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        VolumeCgSnapShotInfo info = JsonUtil.jsonToBean(json.getString("cgsnapshot"), VolumeCgSnapShotInfo.class);
        return info;
    }

    @Override
    public AsyncTaskResponse deleteVolCgSnapShot(String volCgSnapShotId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volCgSnapShotId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_DELETE_VOLCGSNAPSHOT.getUri(), projId, volCgSnapShotId);
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        LOG.info((Object)"DeleteVolCgSnapShot response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolCgSnapShotResponse(regionUuid, tokenId, projUuid, volCgSnapShotId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Bad Request deleteVolCgSnapShot: " + volCgSnapShotId));
        response.setErrorCode("1073948916");
        return response;
    }

    private AsyncTaskResponse checkDeleteVolCgSnapShotResponse(final String regionUuid, final String tokenId, final String projUuid, final String volCgSnapShotId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volCgSnapShotId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgSnapShotInfo volCgSnapShot = CinderManager.this.queryVolCgSnapShot(regionUuid, tokenId, projUuid, volCgSnapShotId);
                if (null == volCgSnapShot) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VolumeStatusE.DELETING.getType().equals(volCgSnapShot.getStatus())) {
                    LOG.error((Object)("VolCgSnapShot status is not excepted, excepted status: deleting, current status : " + volCgSnapShot.getStatus() + ", volCgSnapShot id: " + volCgSnapShotId));
                    response.setSuccess(false);
                    response.setErrorCode("1073948916");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public List<VolumeSnapShotInfo> queryVolumeSnapShots(String regionUuid, String tokenId, String projectUuid, Map<String, String> filterProp) {
        String cacheKey;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projectUuid)) {
            LOG.error((Object)"Failed query volume snapShots.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<VolumeSnapShotInfo> snapShotsList = new ArrayList<VolumeSnapShotInfo>();
        ServiceEndpointUtil endpointUtil = ServiceEndpointUtil.getInstance();
        String urlStr = endpointUtil.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        if (VerifyUtil.isEmpty(filterProp)) {
            filterProp = new HashMap<String, String>();
        }
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.OPENSTACK_SNAPSHOT_LIST, cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{regionUuid, projectUuid, JsonUtil.beanToJson(filterProp)}))) {
            List snapShotList = (List)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_SNAPSHOT_LIST, cacheKey);
            return new ArrayList<VolumeSnapShotInfo>(snapShotList);
        }
        String newUrlStr = urlStr + this.getDetailUrl(filterProp, projId);
        LOG.info((Object)"Query volume snapShots.request str=%s", new Object[]{newUrlStr});
        String limit = String.valueOf(1000);
        filterProp.put("limit", limit);
        int offset = 0;
        String respStr = null;
        while (true) {
            filterProp.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr, filterProp, tokenId, new int[0]);
            LOG.info((Object)"Query volume snapShots. response str=%s", new Object[]{respStr});
            List<VolumeSnapShotInfo> list = this.getSnapShotFromRespStr(respStr);
            snapShotsList.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        OpenstackCache.putCache(OpenstackCache.CacheType.OPENSTACK_SNAPSHOT_LIST, cacheKey, new ArrayList(snapShotsList));
        return snapShotsList;
    }

    private List<VolumeSnapShotInfo> getSnapShotFromRespStr(String respStr) {
        LOG.info((Object)"Query volume snapShots. response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to query volume snapShots.response string is empty.request str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"snapshots")) {
            LOG.error((Object)("Failed to  query volume snapShots.bad Request getVolumeSnapShots response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonArrayToList(json.getString("snapshots"), VolumeSnapShotInfo.class);
    }

    private String getDetailUrl(Map<String, String> filterProp, String projId) {
        if (VerifyUtil.isEmpty(filterProp)) {
            return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOLSNAPSHOTLIST.getUri(), projId);
        }
        if (filterProp.containsKey("volume_id")) {
            return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOLSNAPSHOTS_BY_VOLUME.getUri(), projId);
        }
        return String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_BATCHQUERYQUERY_VOLSNAPSHOTLIST_CG.getUri(), projId);
    }

    @Override
    public VolumeSnapShotInfo queryVolumeSnapShotByUuid(String regionUuid, String tokenId, String projectUuid, String volSnapShotId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)volSnapShotId)) {
            LOG.error((Object)"Failed to query volume snapshot detail.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ServiceEndpointUtil endpointUtil = ServiceEndpointUtil.getInstance();
        String urlStr = endpointUtil.getBaseUrl(regionUuid, "volume");
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(openstackUuid);
        if (null == open) {
            LOG.error((Object)"Failed to query volume snapshot detail.openstack is not discovery");
            throw new LegoCheckedException(1073947393L);
        }
        String url = OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOLSNAPSHOT_DETAIL.getUri();
        if (VerifyUtil.isEmpty((String)open.getVersion()) || "6.0".equals(open.getVersion())) {
            url = OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOLSNAPSHOT.getUri();
        }
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, url, projId, volSnapShotId);
        LOG.debug((Object)"Query volume snapshot detail.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.info((Object)"Query volume snapshot detail. success:response str=%s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Failed to query volume snapshot detail.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.info((Object)"Query volume snapshot detail. snapshot is null.");
            return null;
        }
        if (!json.containsKey((Object)"snapshot")) {
            LOG.error((Object)("Failed to query volume snapshot detail.bad Request queryVolumeSnapShotBySnapId.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(json.getString("snapshot"), VolumeSnapShotInfo.class);
    }

    @Override
    public AsyncTaskResponse createVolumeConsistenceGroup(VolumeCgCreateInfo volCgCreateInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volCgCreateInfo)) {
            LOG.error((Object)"Failed to create volume consistenceGroup.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_CREATE_VOLCG.getUri(), projId);
        String volCgStr = JsonUtil.beanToJson(volCgCreateInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"consistencygroup", (Object)volCgStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, reqestJson.toString(), tokenId);
        LOG.info((Object)"CreateVolumeConsistencyGroup response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948913L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"consistencygroup")) {
            LOG.error((Object)("Bad Request createVolumeConsistenceGroup :" + volCgCreateInfo));
            throw new LegoCheckedException(1073948913L);
        }
        LOG.debug((Object)"Consistencygroup is:%s", new Object[]{json.getString("consistencygroup")});
        VolumeCgInfo info = JsonUtil.jsonToBean(json.getString("consistencygroup"), VolumeCgInfo.class);
        if (null == info) {
            LOG.error((Object)("Convert to VolumeCgInfo return null, Str=" + json.getString("consistencygroup")));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.VolcgStatusE.AVAIABLE.getValue().equals(info.getStatus())) {
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolCgResponse(regionUuid, tokenId, projUuid, info);
    }

    private AsyncTaskResponse checkCreateVolCgResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeCgInfo info) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(info, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgInfo volCg = CinderManager.this.queryVolConsistencyGroup(regionUuid, tokenId, projUuid, info.getId());
                if (null == volCg) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolcgStatusE.AVAIABLE.getValue().equals(volCg.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(volCg);
                    return true;
                }
                if (!OpenstackEnumDefine.VolcgStatusE.ERROR.getValue().equals(volCg.getStatus())) {
                    LOG.error((Object)("VolCg status is not excepted, excepted status: available or creating, current status : " + volCg.getStatus() + ", volCg id: " + info.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(volCg);
                    response.setErrorCode("1073948913");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse updateVolumeConsistenceGroup(VolumeCgUpdateInfo volCgUpdateInfo, String regionUuid, String tokenId, String projUuid, String volCgUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volCgUpdateInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_UPDATE_VOLCG.getUri(), projId, volCgUuid);
        String volCgStr = JsonUtil.beanToJson(volCgUpdateInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"consistencygroup", (Object)volCgStr);
        ClientUtil.sendPutRequest(newUrlStr, reqestJson.toString(), tokenId);
        VolumeCgInfo info = new VolumeCgInfo();
        info.setId(volCgUuid);
        return this.checkCreateVolCgResponse(regionUuid, tokenId, projUuid, info);
    }

    @Override
    public VolumeCgInfo queryVolConsistencyGroup(String regionUuid, String tokenId, String projUuid, String voCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)voCgId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_QUERY_VOLCG.getUri(), projId, voCgId);
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        LOG.info((Object)"QueryVolConsistencyGroup response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            return null;
        }
        if (!json.containsKey((Object)"consistencygroup")) {
            LOG.error((Object)"Bad Request queryVolConsistencyGroup");
            throw new LegoCheckedException(0x300001L);
        }
        return JsonUtil.jsonToBean(json.getString("consistencygroup"), VolumeCgInfo.class);
    }

    @Override
    public AsyncTaskResponse deleteVolumeConsistencyGroup(String volCgId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volCgId)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_DELETE_VOLCG.getUri(), projId, volCgId);
        JSONObject jsonInfo = new JSONObject();
        jsonInfo.put((Object)"force", (Object)"true");
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"consistencygroup", (Object)jsonInfo.toString());
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, reqestJson.toString(), tokenId);
        LOG.info((Object)"DeleteVolumeConsistenceGroup response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolCgResponse(regionUuid, tokenId, projUuid, volCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Bad Request deleteVolumeConsistenceGroup: " + volCgId));
        response.setErrorCode("3145729");
        return response;
    }

    private AsyncTaskResponse checkDeleteVolCgResponse(final String regionUuid, final String tokenId, final String projUuid, final String volCgId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(volCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeCgInfo volCg = CinderManager.this.queryVolConsistencyGroup(regionUuid, tokenId, projUuid, volCgId);
                if (null == volCg) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VolumeStatusE.DELETING.getType().equals(volCg.getStatus())) {
                    LOG.error((Object)("VolCg status is not excepted, excepted status: deleting, current status : " + volCg.getStatus() + ", volCg id: " + volCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public ImageMetadataInfo queryImageMetadata(String regionUuid, String tokenId, String projUuid, String volumeId) {
        Map map = this.queryImageMetadataMap(regionUuid, tokenId, projUuid, volumeId);
        return JsonUtil.jsonToBean(JSONObject.fromObject((Object)map).toString(), ImageMetadataInfo.class);
    }

    @Override
    public Map queryImageMetadataMap(String regionUuid, String tokenId, String projUuid, String volumeId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)"Query image metadata failed. parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        volumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        String message = "{\"os-show_image_metadata\": null}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        LOG.debug((Object)"Query image metadata. volumeId=%s, request str:%s", new Object[]{volumeId, newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Query image metadata. volumeId=%s, response str:%s", new Object[]{volumeId, respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Query image metadata failed. volumeId=" + volumeId + ", respStr is null, request str" + newUrlStr + ", response str" + respStr));
            return null;
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Query image metadata failed. volumeId=" + volumeId + ", respStr contain itemNotFound, request str" + newUrlStr + ", response str" + respStr));
            return null;
        }
        return (Map)JSONObject.toBean((JSONObject)json.getJSONObject("metadata"), Map.class);
    }

    @Override
    public void updateImageMetadata(String regionUuid, String tokenId, String projUuid, ImageMetadataInfo metadataInfo, String volumeId) {
        LOG.debug((Object)"Update image metadata info.volumeId=%s", new Object[]{volumeId});
        if (null == metadataInfo || VerifyUtil.isEmpty((String)metadataInfo.getHwDiskBus())) {
            LOG.error((Object)("Update image metadata, metadataInfo is empty or metadataInfo have no diskbus,volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)("Update image metadata, parameter is empty, volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> volumeImageMetadata = new HashMap<String, String>();
        volumeImageMetadata.put("hw_disk_bus", metadataInfo.getHwDiskBus());
        Map map = this.updateImageMetadata(regionUuid, tokenId, projUuid, volumeImageMetadata, volumeId);
        String rtnJson = JSONObject.fromObject((Object)map).toString();
        ImageMetadataInfo imageMetadataInfo = JsonUtil.jsonToBean(rtnJson, ImageMetadataInfo.class);
        if (null == imageMetadataInfo || !metadataInfo.getHwDiskBus().equals(imageMetadataInfo.getHwDiskBus())) {
            LOG.error((Object)("Update hw disk bus error.Queryed imageMetadataInfo is null or ,Updated metadataInfo(" + metadataInfo.getHwDiskBus() + ") is not equal Query metadataInfo(" + (imageMetadataInfo != null ? imageMetadataInfo.getHwDiskBus() : "") + ".),response str=" + rtnJson + ",volumeId=" + volumeId));
            throw new LegoCheckedException(1073948126L);
        }
    }

    @Override
    public Map updateImageMetadata(String regionUuid, String tokenId, String projUuid, Map<String, String> volumeImageMetadata, String volumeId) {
        LOG.debug((Object)"Update image metadata map info.volumeId=%s", new Object[]{volumeId});
        if (VerifyUtil.isEmpty(volumeImageMetadata)) {
            LOG.error((Object)("Update image metadata map , metadataInfo is empty,volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId)) {
            LOG.error((Object)("Update image metadata map, parameter is empty, volumeId=" + volumeId));
            throw new LegoCheckedException(1073947393L);
        }
        String imageMetaData = JSONObject.fromObject(volumeImageMetadata).toString();
        String message = "{\"os-set_image_metadata\":{\"metadata\":" + imageMetaData + "}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        volumeId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_VOL_ACTION.getUri(), projId, volumeId);
        LOG.debug((Object)"Update image metadata map info.request str=%s,volumeId=%s", new Object[]{newUrlStr, volumeId});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        LOG.debug((Object)"Update image metadata map info.response str=%s,volumeId=%s", new Object[]{respStr, volumeId});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Update image metadata map error.request str=" + newUrlStr + ",imageMetaData str=" + imageMetaData + ",response str=" + respStr + ",volumeId=" + volumeId));
            throw new LegoCheckedException(1073948126L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            LOG.error((Object)("Update image metadata map error.response str=" + json + ",imageMetaData str=" + imageMetaData + ",response str=" + respStr + ",volumeId=" + volumeId));
            throw new LegoCheckedException(1073948126L);
        }
        return JsonUtil.jsonToBean(json.getString("metadata"), Map.class);
    }

    @Override
    public AsyncTaskResponse createVolSnapshot(String regionUuid, String projectUuid, String tokenId, CreateVolumeSnapShotInfo info) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((Object)info)) {
            LOG.error((Object)"Faild to create volume snapshot.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_CREATE_VOLSNAPSHOT.getUri(), projId);
        JSONObject msg = new JSONObject();
        msg.put((Object)"snapshot", (Object)JsonUtil.beanToJson(info));
        LOG.debug((Object)"Create volume snapshot.request str:%s, newUrlStr: %s", new Object[]{msg, newUrlStr});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, msg.toString(), tokenId);
        LOG.debug((Object)"Create volume snapshot. response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)("Faild to create volume snapshot.response string is empty.request str:" + msg + ", newUrlStr" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (!json.containsKey((Object)"snapshot")) {
            LOG.error((Object)("Faild to create volume snapshot.bad Request createSnapshot :" + info.getVolumeId() + ", request str:" + msg + ", newUrlStr" + newUrlStr + ", response: " + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        VolumeSnapShotInfo snapShotInfo = JsonUtil.jsonToBean(json.getString("snapshot"), VolumeSnapShotInfo.class);
        return this.checkCreateVolSnapShot(regionUuid, tokenId, projectUuid, snapShotInfo);
    }

    @Override
    public void activeVolSnapShot(String regionUuid, String projectUuid, String tokenId, VolumeSnapshotActiveInfo snapshotInfo) {
        LOG.error((Object)"Failed to active volume snapShot,does not support this operation under current openstack.");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private AsyncTaskResponse checkCreateVolSnapShot(final String regionUuid, final String tokenId, final String projectUuid, final VolumeSnapShotInfo snapShotInfo) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(snapShotInfo, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                String volSnapShotId = snapShotInfo.getId();
                LOG.debug((Object)"Check snapshot (%s) create snapshot", new Object[]{volSnapShotId});
                VolumeSnapShotInfo snapInfo = CinderManager.this.queryVolumeSnapShotByUuid(regionUuid, tokenId, projectUuid, volSnapShotId);
                if (null == snapInfo) {
                    LOG.error((Object)("Check create snapshot failed.snapshot is null. SnapShotId=" + volSnapShotId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.VolcgsnapshotStatusE.AVAIABLE.getValue().equals(snapInfo.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(snapInfo);
                    return true;
                }
                if (!OpenstackEnumDefine.VolsnapshotStatusE.CREATING.getValue().equals(snapInfo.getStatus())) {
                    LOG.error((Object)("Check create snapshot failed.snapShot status is not excepted, excepted status: available, current status : " + snapInfo.getStatus() + ", snapShot id: " + snapInfo.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(snapInfo);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse deleteVolSnapShotById(String regionUuid, String projUuid, String tokenId, String snapShotId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)snapShotId)) {
            LOG.error((Object)"Failed to delete volume snaphost.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_DELETE_VOLSNAPSHOT.getUri(), projId, snapShotId);
        LOG.debug((Object)"Delete volume snaphost.request str=%s", new Object[]{newUrlStr});
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, tokenId);
        LOG.debug((Object)"DeleteSnapShot response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolSnapshotResponse(regionUuid, tokenId, projUuid, snapShotId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        LOG.error((Object)("Failed to delete volume snaphost.bad Request deleteSnapShot.request str=" + newUrlStr + ", response: " + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private AsyncTaskResponse checkDeleteVolSnapshotResponse(final String regionUuid, final String tokenId, final String projUuid, final String snapShotId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(snapShotId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeSnapShotInfo info = CinderManager.this.queryVolumeSnapShotByUuid(regionUuid, tokenId, projUuid, snapShotId);
                if (null == info) {
                    LOG.error((Object)("Failed to check delete volume snaphost. snapshot is null and snapShotId=" + snapShotId));
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.VolsnapshotStatusE.DELETING.getValue().equals(info.getStatus())) {
                    LOG.error((Object)("Failed to check delete volume snaphost.snapShot status is not excepted, excepted status: deleting, current status : " + info.getStatus() + ", snapShotId id: " + snapShotId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public void updateVolume(String regionUuid, String tokenId, String projUuid, String volumeId, VolumeUpdateInfo volInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)volumeId) || null == volInfo) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)volInfo.getName()) && VerifyUtil.isEmpty((String)volInfo.getDescription())) {
            LOG.error((Object)"Name and description is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String volId = OpenStackCommonUtil.getIdFromUuid(volumeId);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ENGLISH, OpenstackEnumDefine.RequestUrl.CINDER_UPDATE_VOL.getUri(), projId, volId);
        String volStr = JsonUtil.beanToJson(volInfo);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"volume", (Object)volStr);
        String respStr = ClientUtil.sendPutRequest(newUrlStr, reqestJson.toString(), tokenId);
        LOG.info((Object)"UpdateVolume response: %s", new Object[]{respStr});
        if (VerifyUtil.isEmpty((String)respStr)) {
            LOG.error((Object)"Response string is empty");
            throw new LegoCheckedException(1073948132L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("volume").isMissingNode()) {
            LOG.error((Object)("Bad Request updateVolume :" + volInfo));
            throw new LegoCheckedException(1073948132L);
        }
    }

    @Override
    public OpenStackVolume getVolumeForOpenstackVolume(String regionUuid, String tokenId, String projUuid, String uuidVolume) {
        VolumeInfo volumeInfo = this.queryVolume(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(uuidVolume));
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        return this.translateVolume(volumeInfo, openstackUuid, regionUuid, new ArrayList<OpenStackVM>());
    }
}

