/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapshotActiveInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.Locale;

public class CinderManagerMitaka
extends CinderManager {
    private static final Log LOG = LogFactory.getInstance(CinderManager.class);

    @Override
    public void activeVolSnapShot(String regionUuid, String projectUuid, String tokenId, VolumeSnapshotActiveInfo snapshotInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((Object)snapshotInfo)) {
            LOG.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "volume");
        String newUrlStr = urlStr + String.format(Locale.ROOT, OpenstackEnumDefine.RequestUrl.CINDER_ACTIVE_VOLSNAPSHOTS.getUri(), projId);
        String msg = JsonUtil.beanToJson(snapshotInfo);
        LOG.info((Object)"Msg is:%s", new Object[]{msg});
        String respStr = ClientUtil.sendPostRequest(newUrlStr, msg, tokenId);
        LOG.info((Object)"CreateSnapShot response: %s", new Object[]{respStr});
    }
}

